package es.upv.dsic.issi.dplfw.repomanager.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class RepositoryManagerUIPlugin extends AbstractUIPlugin {


	// The plug-in ID
	public static final String PLUGIN_ID = "es.upv.dsic.issi.dplfw.repomanager.ui"; //$NON-NLS-1$

	// Extension points ID constants
	public static final String IECREATION_EXT_POINT_ID = "es.upv.dsic.issi.dplfw.repomanager.ui.iecreation"; //$NON-NLS-1$
	public static final String IECREATION_EXT_POINT_LABEL = "label"; //$NON-NLS-1$
	public static final String IECREATION_EXT_POINT_ICON = "icon"; //$NON-NLS-1$
	public static final String IECREATION_EXT_POINT_IECLASS = "InfoElementClass"; //$NON-NLS-1$

	// The repositories preferences page ID
	public static final String PREFERENCES_REPOSITORIES_ID = "es.upv.dsic.issi.dplfw.repomanager.ui.preferences.RepositoriesPreferencePage"; //$NON-NLS-1$

	// The shared instance
	private static RepositoryManagerUIPlugin plugin;
	
	// Image constants
	public static final String IMG_ELCL16_CONNECT= "IMG_ELCL16_CONNECT"; //$NON-NLS-1$
	public static final String IMG_ELCL16_DISCONNECT = "IMG_ELCL16_DISCONNECT"; //$NON-NLS-1$
	public static final String IMG_ELCL16_MANAGE = "IMG_ELCL16_MANAGE"; //$NON-NLS-1$
	public static final String IMG_ELCL16_EDIT = "IMG_ELCL16_EDIT"; //$NON-NLS-1$
	public static final String IMG_ELCL16_REFRESH = "IMG_ELCL16_REFRESH"; //$NON-NLS-1$
	public static final String IMG_ELCL16_SEARCH = "IMG_ELCL16_SEARCH"; //$NON-NLS-1$
	
	public static final String IMG_OBJ16_CDORESOURCE = "IMG_OBJ16_CDORESOURCE"; //$NON-NLS-1$
	public static final String IMG_OBJ16_CDORESOURCEFOLDER = "IMG_OBJ16_CDORESOURCEFOLDER"; //$NON-NLS-1$
	public static final String IMG_OBJ16_REPOSITORY = "IMG_OBJ16_REPOSITORY"; //$NON-NLS-1$

	public static final String IMG_VIEW16_REPOSITORIES = "IMG_VIEW16_REPOSITORIES"; //$NON-NLS-1$

	
	/**
	 * The constructor
	 */
	public RepositoryManagerUIPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static RepositoryManagerUIPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);
		reg.put(IMG_ELCL16_CONNECT, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/connect.png").createImage());
		reg.put(IMG_ELCL16_DISCONNECT, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/disconnect.png").createImage());
		reg.put(IMG_ELCL16_MANAGE, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/manage.png").createImage());
		reg.put(IMG_ELCL16_EDIT, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/edit.gif").createImage());
		reg.put(IMG_ELCL16_REFRESH, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/refresh.gif").createImage());
		reg.put(IMG_ELCL16_SEARCH, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/elcl16/search_src.gif").createImage());
		reg.put(IMG_OBJ16_CDORESOURCE, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/obj16/CDOResource.gif").createImage());
		reg.put(IMG_OBJ16_CDORESOURCEFOLDER, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/obj16/CDOResourceFolder.gif").createImage());
		reg.put(IMG_OBJ16_REPOSITORY, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/obj16/RepositoryLocation.gif").createImage());
		reg.put(IMG_VIEW16_REPOSITORIES, RepositoryManagerUIPlugin
				.getImageDescriptor("icons/full/view16/repositories.gif").createImage());

	}
}
