/*
 * Decompiled with CFR 0.152.
 */
package org.dita_op.dost.launcher.dplfwfragment.launcher;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.dita_op.dost.launcher.internal.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class DOSTLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            this.launch(file, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).getFirstElement(), mode);
        }
    }

    protected void launch(Object type, String mode) {
        IFile file = null;
        file = type instanceof IFile ? (IFile)type : (IFile)((IResource)type).getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(file);
            if (config != null) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)config, (String)"org.eclipse.debug.ui.launchGroup.run", null);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log(4, (Exception)((Object)e));
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(IFile file) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("org.dita_op.dost.launcher.DOSTLaunchConfigurationType");
        String fileInput = NLS.bind((String)"$'{'resource_loc:{0}'}'", (Object)file.getFullPath().toString());
        ILaunchConfiguration[] existingConfigs = launchManager.getLaunchConfigurations(launchType);
        ILaunchConfigurationWorkingCopy launchConf = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = existingConfigs;
        int n = existingConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration existingConfig = iLaunchConfigurationArray[n2];
            if (StringUtils.equals((CharSequence)existingConfig.getAttribute("args.input", ""), (CharSequence)fileInput)) {
                launchConf = existingConfig.getWorkingCopy();
                break;
            }
            ++n2;
        }
        if (launchConf == null) {
            String launchName = StringUtils.capitalize((String)file.getFullPath().removeFileExtension().lastSegment());
            launchConf = launchType.newInstance(null, launchName);
            launchConf.setAttribute("transtype", "pdf");
            HashMap<String, String> defaultArgs = new HashMap<String, String>();
            defaultArgs.put("dita.extname", ".dita");
            defaultArgs.put("args.csspath", "css");
            defaultArgs.put("args.eclipsehelp.toc", "toc");
            defaultArgs.put("args.eclipsecontent.toc", "toc");
            defaultArgs.put("args.eclipse.provider", "dita-op.org");
            defaultArgs.put("args.eclipse.version", "1.0.0.qualifier");
            launchConf.setAttribute("other.args", defaultArgs);
            if (file.getProject().hasNature(DplfwPlugin.NATURE_ID)) {
                launchConf.setAttribute("output.dir", NLS.bind((String)"$'{'resource_loc:{0}'}'", (Object)IDplProject.create((IProject)file.getProject()).getOutputFolder().getFolder().getFullPath().toString()));
            } else {
                launchConf.setAttribute("output.dir", NLS.bind((String)"$'{'resource_loc:{0}'}'", (Object)file.getParent().getFullPath().toString()));
            }
            launchConf.setAttribute("transtype", "xhtml");
            launchConf.setAttribute("args.input", fileInput);
        }
        return launchConf.doSave();
    }
}

