package org.dita_op.dost.launcher.dplfwfragment.launcher;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.dita_op.dost.launcher.internal.Activator;
import org.dita_op.dost.launcher.internal.DOSTParameters;
import org.dita_op.dost.launcher.internal.ui.launchConfiguration.DOSTLaunchConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

public class DOSTLaunchShortcut implements ILaunchShortcut {

	public void launch(IEditorPart editor, String mode) {
		IEditorInput input = editor.getEditorInput();
		IFile file = (IFile) input.getAdapter(IFile.class);
		if (file != null) {
			launch(file, mode);
		}
	}

	public void launch(ISelection selection, String mode) {
		if (selection instanceof IStructuredSelection) {
			launch(((IStructuredSelection) selection).getFirstElement(), mode);
		}
	}

	protected void launch(Object type, String mode) {
		IFile file = null;
		if (type instanceof IFile) {
			file = (IFile) type;
		} else {
			file = (IFile) ((IResource) type).getAdapter(IFile.class);
		}
		if (file == null) {
			return;
		}

		try {
			ILaunchConfiguration config = findLaunchConfiguration(file);
			if (config != null) {
				Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
				DebugUITools.openLaunchConfigurationDialog(shell, config, IDebugUIConstants.ID_RUN_LAUNCH_GROUP, null);
			}
		} catch (CoreException e) {
			Activator.getDefault().log(IStatus.ERROR, e);
		}
	}

	private ILaunchConfiguration findLaunchConfiguration(IFile file) throws CoreException {
		ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("org.dita_op.dost.launcher.DOSTLaunchConfigurationType");

		String fileInput = NLS.bind("$'{'resource_loc:{0}'}'", file.getFullPath().toString());
		ILaunchConfiguration[] existingConfigs = launchManager.getLaunchConfigurations(launchType);
		
		ILaunchConfigurationWorkingCopy launchConf = null;
		
		for (ILaunchConfiguration existingConfig : existingConfigs) {
			if (StringUtils.equals(existingConfig.getAttribute(DOSTParameters.ARGS_INPUT, StringUtils.EMPTY), fileInput)) {
				launchConf = existingConfig.getWorkingCopy();
				break;
			}
		}
		if (launchConf == null) {
			String launchName = StringUtils.capitalize(file.getFullPath().removeFileExtension().lastSegment());
			launchConf = launchType.newInstance(null, launchName);
			//launchConf.setAttribute(DOSTParameters.TRANSTYPE, DOSTParameters.DEFAULT_TRANSTYPE);
			launchConf.setAttribute(DOSTParameters.TRANSTYPE, "pdf");
	
			Map<String, String> defaultArgs = new HashMap<String, String>();
	
			defaultArgs.put(DOSTParameters.DITA_EXTNAME, ".dita"); //$NON-NLS-1$
			defaultArgs.put(DOSTParameters.ARGS_CSSPATH, "css"); //$NON-NLS-1$
			defaultArgs.put(DOSTParameters.ARGS_ECLIPSEHELP_TOC, "toc"); //$NON-NLS-1$
			defaultArgs.put(DOSTParameters.ARGS_ECLIPSECONTENT_TOC, "toc"); //$NON-NLS-1$
			defaultArgs.put(DOSTParameters.ARGS_ECLIPSE_PROVIDER, "dita-op.org"); //$NON-NLS-1$
			defaultArgs.put(DOSTParameters.ARGS_ECLIPSE_VERSION, "1.0.0.qualifier"); //$NON-NLS-1$
	
			launchConf.setAttribute(DOSTLaunchConfigurationConstants.OTHER_ARGS, defaultArgs);
			
			if (file.getProject().hasNature(DplfwPlugin.NATURE_ID)) {
				launchConf.setAttribute(DOSTParameters.OUTPUT_DIR, NLS.bind("$'{'resource_loc:{0}'}'", IDplProject.create(file.getProject()).getOutputFolder().getFolder().getFullPath().toString()));
			} else {
				launchConf.setAttribute(DOSTParameters.OUTPUT_DIR, NLS.bind("$'{'resource_loc:{0}'}'", file.getParent().getFullPath().toString()));
			}
			launchConf.setAttribute(DOSTParameters.TRANSTYPE, DOSTParameters.DEFAULT_TRANSTYPE);
			launchConf.setAttribute(DOSTParameters.ARGS_INPUT, fileInput);
		}

		return launchConf.doSave();
	}

}
