package org.dita_op.dost.launcher.dplfwfragment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;

import org.dita_op.dost.launcher.internal.Activator;
import org.dita_op.dost.launcher.internal.DOSTParameters;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;

public class DOSTPreferenceInitializer extends AbstractPreferenceInitializer {

	public DOSTPreferenceInitializer() {
	}

	@Override
	public void initializeDefaultPreferences() {
		try {
			URL url = FileLocator.toFileURL(FileLocator.find(
					Activator.getDefault().getBundle(), 
					new Path("/dita-ot-2.5.4"), 
					Collections.emptyMap()));
			File file = new File(url.getFile());
			Activator.getDefault().getPreferenceStore().setDefault(
					DOSTParameters.DITA_DIR,
					file.getAbsolutePath());
		} catch (IOException e) {
			Activator.getDefault().getLog().log(
					new Status(IStatus.ERROR, Activator.PLUGIN_ID, e.getLocalizedMessage(), e));
		}
	}

}
