/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.om.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;

import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.User;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>User</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#getBelongsTo <em>Belongs To</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#getManages <em>Manages</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#getLogin <em>Login</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#getHash <em>Hash</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#getSalt <em>Salt</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.om.impl.UserImpl#isDisabled <em>Disabled</em>}</li>
 * </ul>
 *
 * @generated
 */
public class UserImpl extends ActorImpl implements User {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UserImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return OmPackage.Literals.USER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Unit> getBelongsTo() {
		return (EList<Unit>)eGet(OmPackage.Literals.USER__BELONGS_TO, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Unit> getManages() {
		return (EList<Unit>)eGet(OmPackage.Literals.USER__MANAGES, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLogin() {
		return (String)eGet(OmPackage.Literals.USER__LOGIN, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLogin(String newLogin) {
		eSet(OmPackage.Literals.USER__LOGIN, newLogin);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public byte[] getHash() {
		return (byte[])eGet(OmPackage.Literals.USER__HASH, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHash(byte[] newHash) {
		eSet(OmPackage.Literals.USER__HASH, newHash);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public byte[] getSalt() {
		return (byte[])eGet(OmPackage.Literals.USER__SALT, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSalt(byte[] newSalt) {
		eSet(OmPackage.Literals.USER__SALT, newSalt);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDisabled() {
		return (Boolean)eGet(OmPackage.Literals.USER__DISABLED, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDisabled(boolean newDisabled) {
		eSet(OmPackage.Literals.USER__DISABLED, newDisabled);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isValidPassword(final String password) {
		byte[] salt = getSalt();
		byte[] hash = getHash();
		byte[] newHash = getHash();
			
		try {
			MessageDigest digest = MessageDigest.getInstance("SHA-256");
			digest.update(salt);
			newHash = digest.digest(password.getBytes("UTF-8"));
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return Arrays.equals(hash, newHash);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPassword(final String password) {
		byte[] salt = new byte[32];
		byte[] hash = new byte[32];
		
		// Initialize salt
		new Random().nextBytes(salt);
		
		// Calculate hash = SHA-256(salt + password)
		try {
			MessageDigest digest = MessageDigest.getInstance("SHA-256");
			digest.update(salt);
			hash = digest.digest(password.getBytes("UTF-8"));
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
				
		// Save values
		setHash(hash);
		setSalt(salt);
	}

} //UserImpl
