/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.presentation.commands.SavePasswordCommand;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.ActorDetailsPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class UserDetailsPage
extends ActorDetailsPage {
    private Text loginText;
    private Text passwordText;
    private Text repasswordText;
    protected Button disabledButton;
    protected boolean needsSavePassword = false;

    public UserDetailsPage(EditingDomain editingDomain) {
        super(editingDomain);
        this.setText("User details");
        this.setDescription("Set the properties of the selected User. Required fields are denoted by \"*\".");
    }

    @Override
    protected void createFields(Composite detailsClient) {
        this.createUuidField(detailsClient);
        this.createNameField(detailsClient);
        this.createLoginField(detailsClient);
        this.createPasswordField(detailsClient);
        this.createRePasswordField(detailsClient);
        this.createEmailField(detailsClient);
        this.createDescriptionField(detailsClient);
        this.createDisabledStateField(detailsClient);
    }

    private void createLoginField(Composite detailsClient) {
        Label loginLabel = this.getToolkit().createLabel(detailsClient, "Login*:");
        loginLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.loginText = this.getToolkit().createText(detailsClient, "");
        this.loginText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.loginText.addListener(24, (Listener)this.modifyListener);
    }

    private void createRePasswordField(Composite detailsClient) {
        Label repasswordLabel = this.getToolkit().createLabel(detailsClient, "Reenter password*:");
        repasswordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.repasswordText = this.getToolkit().createText(detailsClient, "", 0x400000);
        this.repasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.repasswordText.addListener(24, (Listener)this.modifyListener);
        this.repasswordText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!StringUtil.isEmpty((String)UserDetailsPage.this.repasswordText.getText())) {
                    UserDetailsPage.this.needsSavePassword = true;
                }
            }
        });
    }

    private void createPasswordField(Composite detailsClient) {
        Label passwordLabel = this.getToolkit().createLabel(detailsClient, "Password*:");
        passwordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.passwordText = this.getToolkit().createText(detailsClient, "", 0x400000);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passwordText.addListener(24, (Listener)this.modifyListener);
        this.passwordText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!StringUtil.isEmpty((String)UserDetailsPage.this.passwordText.getText())) {
                    UserDetailsPage.this.needsSavePassword = true;
                }
            }
        });
    }

    protected void createDisabledStateField(Composite detailsClient) {
        Composite composite = this.getToolkit().createComposite(detailsClient);
        composite.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        composite.setLayout((Layout)new FillLayout(256));
        this.disabledButton = this.getToolkit().createButton(composite, "The account is disabled", 32);
        this.disabledButton.addListener(13, (Listener)this.modifyListener);
    }

    @Override
    protected CompoundCommand buildCommitCommand() {
        CompoundCommand command = super.buildCommitCommand();
        command.append((Command)new SetCommand(this.editingDomain, (EObject)this.getInput(), (EStructuralFeature)OmPackage.eINSTANCE.getUser_Login(), (Object)this.loginText.getText()));
        command.append((Command)new SetCommand(this.editingDomain, (EObject)this.getInput(), (EStructuralFeature)OmPackage.eINSTANCE.getUser_Disabled(), (Object)this.disabledButton.getSelection()));
        if (this.needsSavePassword) {
            command.append((Command)new SavePasswordCommand(this.getInput(), this.passwordText.getText()));
            this.needsSavePassword = false;
        }
        return command;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.getInput() != null) {
            this.modifyListener.disable();
            this.loginText.setText(this.getInput().getLogin() != null ? this.getInput().getLogin() : "");
            this.passwordText.setText("");
            this.repasswordText.setText("");
            this.disabledButton.setSelection(this.getInput().isDisabled());
            this.modifyListener.enable();
        }
    }

    protected User getInput() {
        return (User)this.input;
    }
}

