/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.presentation.commands.CreateUnitCommand;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.ActorBlock;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.UnitDetailsPage;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;

public class UnitsBlock
extends ActorBlock {
    public UnitsBlock(FormPage page) {
        super(page);
        this.setText("Organizational units");
        this.setDescription("An organizational unit allows to classify users in different groups. Organizational units may have sub-units.");
    }

    @Override
    protected ViewerFilter createViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Unit;
            }
        };
    }

    @Override
    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        super.createMasterPart(managedForm, parent);
        this.initContextMenu();
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)(this).UnitsBlock.this.actorsViewer.getSelection();
                        if (selection.getFirstElement() instanceof Unit) {
                            UnitsBlock.this.createUnit((Unit)selection.getFirstElement());
                        } else {
                            UnitsBlock.this.createUnit();
                        }
                    }
                };
                action.setText("New &Child Unit");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.actorsViewer.getTree());
        this.actorsViewer.getTree().setMenu(menu);
    }

    @Override
    protected AdapterFactoryContentProvider createViewerContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new OmItemProviderAdapterFactory()){

            public boolean hasChildren(Object object) {
                if (object instanceof Unit) {
                    return !((Unit)object).getHasUnits().isEmpty();
                }
                return super.hasChildren(object);
            }
        };
    }

    @Override
    protected void registerPages(DetailsPart detailsPart) {
        super.registerPages(detailsPart);
        detailsPart.registerPage(OmFactory.eINSTANCE.createUnit().getClass(), (IDetailsPage)new UnitDetailsPage(this.editingDomain));
    }

    @Override
    protected void performNew(SelectionEvent e) {
        this.createUnit(null);
    }

    private void createUnit(Unit parentUnit) {
        CreateUnitCommand command = new CreateUnitCommand(this.input, parentUnit);
        if (command.canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)command);
            Unit newUnit = command.getNewUnit();
            this.actorsViewer.refresh();
            this.actorsViewer.setSelection((ISelection)new StructuredSelection((Object)newUnit));
            this.getManagedForm().dirtyStateChanged();
        }
    }

    private void createUnit() {
        this.createUnit(null);
    }
}

