/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.ActorDetailsPage;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.ActorViewerSorter;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.provider.UserItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Section;

public class UnitDetailsPage
extends ActorDetailsPage {
    private CheckboxTableViewer viewer;
    private Button setManagerButton;
    private Button selectAllButton;
    private Button selectNoneButton;
    private EContentAdapter organizationChangesAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if ((notification.getFeature().equals(OmPackage.eINSTANCE.getOrganization_Users()) || notification.getFeature().equals(OmPackage.eINSTANCE.getActor_Name())) && UnitDetailsPage.this.viewer != null && !UnitDetailsPage.this.viewer.getTable().isDisposed()) {
                UnitDetailsPage.this.viewer.refresh();
            }
        }
    };

    public UnitDetailsPage(EditingDomain editingDomain) {
        super(editingDomain);
        this.setText("Unit details");
        this.setDescription("Set the properties of the selected Unit. Required fields are denoted by \"*\".");
    }

    @Override
    public void createContents(Composite parent) {
        super.createContents(parent);
        Section usersSection = this.getToolkit().createSection(parent, 384);
        usersSection.setText("Organizational Unit Members");
        usersSection.setDescription("Select the members of the Organizational Unit. The User in bold font is the manager.");
        usersSection.marginWidth = 10;
        usersSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite usersClient = this.getToolkit().createComposite((Composite)usersSection, 64);
        GridLayout usersGridLayout = new GridLayout();
        usersGridLayout.marginWidth = 0;
        usersGridLayout.marginHeight = 0;
        usersGridLayout.numColumns = 2;
        usersClient.setLayout((Layout)usersGridLayout);
        usersClient.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData tablesGridData = new GridData(1808);
        tablesGridData.heightHint = 20;
        tablesGridData.widthHint = 100;
        Table candidatesTable = this.getToolkit().createTable(usersClient, 36);
        candidatesTable.setLayoutData((Object)tablesGridData);
        this.viewer = new CheckboxTableViewer(candidatesTable);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider((AdapterFactory)new CustomOmItemProviderAdapterFactory()));
        this.viewer.setSorter((ViewerSorter)new ActorViewerSorter());
        this.viewer.setInput((Object)EcoreUtil.getRootContainer((EObject)this.getInput()));
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (UnitDetailsPage.this.getInput() != null) {
                    return UnitDetailsPage.this.getInput().getUsers().contains(element);
                }
                return false;
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Command command = null;
                command = event.getChecked() ? AddCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Users(), (Object)event.getElement()) : RemoveCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Users(), (Object)event.getElement());
                if (command.canExecute()) {
                    UnitDetailsPage.this.markDirty();
                    UnitDetailsPage.this.editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UnitDetailsPage.this.viewer.getSelection();
                Command command = SetCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Manager(), (Object)selection.getFirstElement());
                if (command.canExecute()) {
                    UnitDetailsPage.this.markDirty();
                    UnitDetailsPage.this.editingDomain.getCommandStack().execute(command);
                    UnitDetailsPage.this.viewer.refresh();
                }
            }
        });
        Composite buttonsComposite = this.getToolkit().createComposite(usersClient);
        GridData layoutData = new GridData(4, 128, false, true);
        buttonsComposite.setLayoutData((Object)layoutData);
        buttonsComposite.setLayout((Layout)new FillLayout(512));
        this.setManagerButton = this.getToolkit().createButton(buttonsComposite, "Set as &Manager", 8);
        this.setManagerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UnitDetailsPage.this.viewer.getSelection();
                Command command = SetCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Manager(), (Object)selection.getFirstElement());
                if (command.canExecute()) {
                    UnitDetailsPage.this.markDirty();
                    UnitDetailsPage.this.editingDomain.getCommandStack().execute(command);
                    UnitDetailsPage.this.viewer.refresh();
                }
            }
        });
        this.getToolkit().createLabel(buttonsComposite, null);
        this.selectAllButton = this.getToolkit().createButton(buttonsComposite, "Select &All", 8);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command command = SetCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Users(), (Object)UnitDetailsPage.this.viewer.getInput());
                if (command.canExecute()) {
                    UnitDetailsPage.this.markDirty();
                    UnitDetailsPage.this.editingDomain.getCommandStack().execute(command);
                    UnitDetailsPage.this.viewer.refresh();
                }
            }
        });
        this.selectNoneButton = this.getToolkit().createButton(buttonsComposite, "Select &None", 8);
        this.selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command command = SetCommand.create((EditingDomain)UnitDetailsPage.this.editingDomain, (Object)UnitDetailsPage.this.getInput(), (Object)OmPackage.eINSTANCE.getUnit_Users(), (Object)SetCommand.UNSET_VALUE);
                if (command.canExecute()) {
                    UnitDetailsPage.this.markDirty();
                    UnitDetailsPage.this.editingDomain.getCommandStack().execute(command);
                    UnitDetailsPage.this.viewer.refresh();
                }
            }
        });
        this.getToolkit().paintBordersFor((Composite)usersSection);
        usersSection.setClient((Control)usersClient);
    }

    @Override
    protected void createFields(Composite detailsClient) {
        this.createUuidField(detailsClient);
        this.createNameField(detailsClient);
        this.createEmailField(detailsClient);
        this.createDescriptionField(detailsClient);
    }

    @Override
    public boolean setFormInput(Object input) {
        super.setFormInput(input);
        Unit unit = (Unit)input;
        Organization organization = (Organization)EcoreUtil.getRootContainer((EObject)((EObject)input));
        if (!organization.eAdapters().contains((Object)this.organizationChangesAdapter)) {
            organization.eAdapters().add((Object)this.organizationChangesAdapter);
        }
        if (unit.getBelongsTo() == null) {
            this.viewer.setInput((Object)organization.getUsers());
        } else {
            this.viewer.setInput((Object)unit.getBelongsTo().getUsers());
        }
        return true;
    }

    protected Unit getInput() {
        return (Unit)this.input;
    }

    private final class CustomOmItemProviderAdapterFactory
    extends OmItemProviderAdapterFactory {
        private CustomOmItemProviderAdapterFactory() {
        }

        public Adapter createUserAdapter() {
            if (this.userItemProvider == null) {
                this.userItemProvider = new UserItemProvider((AdapterFactory)this){

                    public String getText(Object object) {
                        String label = super.getText(object);
                        if (UnitDetailsPage.this.getInput().getManager() != null && UnitDetailsPage.this.getInput().getManager().equals(object)) {
                            return String.valueOf(label) + " [Manager]";
                        }
                        return label;
                    }
                };
            }
            return this.userItemProvider;
        }
    }

    private final class ViewerLabelProvider
    extends AdapterFactoryLabelProvider
    implements IFontProvider {
        private ViewerLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Font getFont(Object object) {
            Font font = UnitDetailsPage.this.viewer.getControl().getFont();
            if (UnitDetailsPage.this.getInput().getManager() != null && UnitDetailsPage.this.getInput().getManager().equals(object)) {
                return JFaceResources.getFontRegistry().getBold(font.getFontData()[0].getName());
            }
            return font;
        }
    }
}

