/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ActorDetailsPage
extends AbstractFormPart
implements IDetailsPage {
    protected String text;
    protected String description;
    protected Actor input;
    protected EditingDomain editingDomain;
    protected Text uuidText;
    protected Text nameText;
    protected Text emailText;
    protected Text descriptionText;
    protected DisableableListener modifyListener = new DisableableListener();

    public ActorDetailsPage(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginLeft = 5;
        layout.marginRight = 2;
        layout.marginBottom = 7;
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section detailsSection = toolkit.createSection(parent, 384);
        detailsSection.marginWidth = 10;
        detailsSection.setText(this.text);
        detailsSection.setDescription(this.description);
        detailsSection.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite detailsClient = toolkit.createComposite((Composite)detailsSection);
        GridLayout detailsGridLayout = new GridLayout();
        detailsGridLayout.marginWidth = 0;
        detailsGridLayout.marginHeight = 0;
        detailsGridLayout.numColumns = 2;
        detailsGridLayout.horizontalSpacing = 14;
        detailsClient.setLayout((Layout)detailsGridLayout);
        this.createFields(detailsClient);
        toolkit.paintBordersFor((Composite)detailsSection);
        detailsSection.setClient((Control)detailsClient);
    }

    protected abstract void createFields(Composite var1);

    protected void createDescriptionField(Composite detailsClient) {
        Label descriptionLabel = this.getToolkit().createLabel(detailsClient, "Description:");
        descriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.descriptionText = this.getToolkit().createText(detailsClient, "");
        this.descriptionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptionText.addListener(24, (Listener)this.modifyListener);
    }

    protected void createEmailField(Composite detailsClient) {
        Label emailLabel = this.getToolkit().createLabel(detailsClient, "E-mail:");
        emailLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.emailText = this.getToolkit().createText(detailsClient, "");
        this.emailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailText.addListener(24, (Listener)this.modifyListener);
    }

    protected void createNameField(Composite detailsClient) {
        Label nameLabel = this.getToolkit().createLabel(detailsClient, "Name*:");
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.nameText = this.getToolkit().createText(detailsClient, "");
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addListener(24, (Listener)this.modifyListener);
    }

    protected void createUuidField(Composite detailsClient) {
        Label uuidLabel = this.getToolkit().createLabel(detailsClient, "UUID:");
        uuidLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.uuidText = this.getToolkit().createText(detailsClient, "");
        this.uuidText.setEditable(false);
        this.uuidText.setEnabled(false);
        this.uuidText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        CompoundCommand command = this.buildCommitCommand();
        if (command.canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)command);
        }
    }

    protected CompoundCommand buildCommitCommand() {
        CompoundCommand command = new CompoundCommand();
        command.append((Command)new SetCommand(this.editingDomain, (EObject)this.input, (EStructuralFeature)OmPackage.eINSTANCE.getActor_Name(), (Object)this.nameText.getText()));
        command.append((Command)new SetCommand(this.editingDomain, (EObject)this.input, (EStructuralFeature)OmPackage.eINSTANCE.getActor_Description(), (Object)this.descriptionText.getText()));
        command.append((Command)new SetCommand(this.editingDomain, (EObject)this.input, (EStructuralFeature)OmPackage.eINSTANCE.getActor_Email(), (Object)this.emailText.getText()));
        return command;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() == 1) {
            this.setFormInput(structuredSelection.getFirstElement());
        } else {
            this.setFormInput(null);
        }
    }

    public boolean setFormInput(Object input) {
        if (this.input != input) {
            this.input = (Actor)input;
            this.refresh();
        }
        return true;
    }

    public void refresh() {
        if (this.input != null) {
            this.modifyListener.disable();
            this.uuidText.setText(this.input.getUuid().toString() != null ? this.input.getUuid().toString() : "");
            this.nameText.setText(this.input.getName() != null ? this.input.getName() : "");
            this.emailText.setText(this.input.getEmail() != null ? this.input.getEmail() : "");
            this.descriptionText.setText(this.input.getDescription() != null ? this.input.getDescription() : "");
            this.modifyListener.enable();
        }
        super.refresh();
    }

    protected FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFocus() {
        this.nameText.setSelection(0, this.nameText.getCharCount());
        this.nameText.setFocus();
    }

    protected abstract <T extends Actor> T getInput();

    protected class DisableableListener
    implements Listener {
        private volatile boolean disabled = false;

        protected DisableableListener() {
        }

        public void handleEvent(Event event) {
            if (!this.disabled) {
                ActorDetailsPage.this.markDirty();
            }
        }

        public void enable() {
            this.disabled = false;
        }

        public void disable() {
            this.disabled = true;
        }
    }
}

