/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.presentation.OmEditorPlugin;
import es.upv.dsic.issi.dplfw.om.presentation.editors.form.ActorViewerSorter;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ActorBlock
extends MasterDetailsBlock {
    protected FormPage page;
    protected DetailsPart detailsPart;
    protected EditingDomain editingDomain;
    protected TreeViewer actorsViewer;
    protected Organization input;
    protected String text = "";
    protected String description = "";

    public ActorBlock(FormPage page) {
        this.page = page;
        Assert.isTrue((boolean)(page.getEditor() instanceof IEditingDomainProvider));
        this.editingDomain = ((IEditingDomainProvider)page.getEditor()).getEditingDomain();
        Resource res = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.input = (Organization)res.getContents().get(0);
        this.input.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature().equals(OmPackage.eINSTANCE.getActor_Name()) && ActorBlock.this.actorsViewer != null && !ActorBlock.this.actorsViewer.getTree().isDisposed()) {
                    ActorBlock.this.actorsViewer.update(notification.getNotifier(), null);
                } else if (notification.getEventType() == 3 && notification.getNewValue() instanceof Actor && !((Actor)notification.getNewValue()).eAdapters().contains((Object)this)) {
                    ((Actor)notification.getNewValue()).eAdapters().add((Object)this);
                }
            }
        });
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.setText(this.text);
        section.setDescription(this.description);
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite clientComposite = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        clientComposite.setLayout((Layout)layout);
        final SectionPart spart = new SectionPart(section);
        section.setClient((Control)clientComposite);
        managedForm.addPart((IFormPart)spart);
        Tree tree = toolkit.createTree(clientComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 20;
        gridData.widthHint = 100;
        tree.setLayoutData((Object)gridData);
        toolkit.paintBordersFor(clientComposite);
        Composite buttonsComposite = toolkit.createComposite(clientComposite);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.widthHint = 100;
        buttonsComposite.setLayoutData((Object)layoutData);
        buttonsComposite.setLayout((Layout)new FillLayout(512));
        Button newButton = toolkit.createButton(buttonsComposite, "&New", 8);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActorBlock.this.performNew(e);
                ActorBlock.this.detailsPart.setFocus();
            }
        });
        Button deleteButton = toolkit.createButton(buttonsComposite, "&Delete", 8);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActorBlock.this.performDelete(e);
            }
        });
        this.actorsViewer = new TreeViewer(tree);
        this.actorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActorBlock.this.page.getManagedForm().fireSelectionChanged((IFormPart)spart, ActorBlock.this.actorsViewer.getSelection());
            }
        });
        this.actorsViewer.setContentProvider((IContentProvider)this.createViewerContentProvider());
        this.actorsViewer.setLabelProvider((IBaseLabelProvider)this.createViewerLabelProvider());
        this.actorsViewer.setSorter((ViewerSorter)new ActorViewerSorter());
        Resource res = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.input = (Organization)res.getContents().get(0);
        this.actorsViewer.setInput((Object)this.input);
        this.actorsViewer.addFilter(this.createViewerFilter());
    }

    protected AdapterFactoryLabelProvider createViewerLabelProvider() {
        return new AdapterFactoryLabelProvider((AdapterFactory)new OmItemProviderAdapterFactory());
    }

    protected AdapterFactoryContentProvider createViewerContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new OmItemProviderAdapterFactory());
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                ActorBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText("Horizontal orientation");
        haction.setImageDescriptor(OmEditorPlugin.getPlugin().getImageRegistry().getDescriptor("horizontal"));
        Action vaction = new Action("ver", 8){

            public void run() {
                ActorBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText("Vertical orientation");
        vaction.setImageDescriptor(OmEditorPlugin.getPlugin().getImageRegistry().getDescriptor("vertical"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected IManagedForm getManagedForm() {
        return this.page.getManagedForm();
    }

    protected FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    protected abstract ViewerFilter createViewerFilter();

    protected abstract void performNew(SelectionEvent var1);

    protected void performDelete(SelectionEvent e) {
        Command command;
        IStructuredSelection selection = (IStructuredSelection)this.actorsViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof Actor && (command = DeleteCommand.create((EditingDomain)this.editingDomain, (Object)element)).canExecute()) {
            this.editingDomain.getCommandStack().execute(command);
            this.actorsViewer.refresh();
            this.getManagedForm().dirtyStateChanged();
        }
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPart = detailsPart;
    }
}

