/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.presentation.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPasswordDialog
extends Dialog {
    private String title = "New password";
    private String value = "";
    private Button okButton;
    private Text password;
    private Text repassword;
    private Text errorMessageText;
    private String errorMessage;

    public NewPasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.password.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.password.setFocus();
        if (this.value != null) {
            this.password.setText(this.value);
            this.password.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText("Password:");
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        GridData data = new GridData(4);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.password = new Text(composite, this.getInputTextStyle());
        this.password.setLayoutData((Object)data);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPasswordDialog.this.validateInput();
            }
        });
        label = new Label(composite, 64);
        label.setText("Reenter password:");
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        this.repassword = new Text(composite, this.getInputTextStyle());
        this.repassword.setLayoutData((Object)data);
        this.repassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPasswordDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        NewPasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.password;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        errorMessage = this.isValid();
        this.setErrorMessage(errorMessage);
    }

    private String isValid() {
        if (!this.password.getText().equals(this.repassword.getText())) {
            return "Passwords do not match";
        }
        return null;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 0x400804;
    }
}

