package es.upv.dsic.issi.dplfw.om.presentation.editors.form;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.editor.FormPage;

import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.presentation.commands.CreateUserCommand;
/**
 *
 */
public class UsersBlock extends ActorBlock {
	
	public UsersBlock(FormPage page) {
		super(page);
		setText("Users");
		setDescription("Select a member of the organization to view and edit its properties.");
	}

	protected ViewerFilter createViewerFilter() {
		return new ViewerFilter() {
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				return element instanceof User;
			}
		};
	}

	

	protected void registerPages(DetailsPart detailsPart) {
		super.registerPages(detailsPart);
		detailsPart.registerPage(OmFactory.eINSTANCE.createUser().getClass(), new UserDetailsPage(editingDomain));
	}

	@Override
	protected void performNew(SelectionEvent e) {
		CreateUserCommand command = new CreateUserCommand(input);
		if (command.canExecute()) {
			editingDomain.getCommandStack().execute(command);
			User newUser = command.getNewUser();
			actorsViewer.refresh();
			actorsViewer.setSelection(new StructuredSelection(newUser));
			getManagedForm().dirtyStateChanged();
		}
	}
}