package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.presentation.commands.SavePasswordCommand;

public class UserDetailsPage extends ActorDetailsPage {

	private Text loginText;
	private Text passwordText;
	private Text repasswordText;
	protected Button disabledButton;
		
	protected boolean needsSavePassword;

	
	public UserDetailsPage(EditingDomain editingDomain) {
		super(editingDomain);
		this.needsSavePassword = false;
		setText("User details");
		setDescription("Set the properties of the selected User. Required fields are denoted by \"*\".");
	}
	
	@Override
	protected void createFields(Composite detailsClient) {

		createUuidField(detailsClient);
		
		createNameField(detailsClient);
	
		createLoginField(detailsClient);

		createPasswordField(detailsClient);
		
		createRePasswordField(detailsClient);
		
		createEmailField(detailsClient);
		
		createDescriptionField(detailsClient);

		createDisabledStateField(detailsClient);
	}

	private void createLoginField(Composite detailsClient) {
		// Login
		Label loginLabel = getToolkit().createLabel(detailsClient, "Login*:");
		loginLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		loginText = getToolkit().createText(detailsClient, "");
		loginText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		loginText.addListener(SWT.Modify, modifyListener);
	}

	private void createRePasswordField(Composite detailsClient) {
		// Re-Password
		Label repasswordLabel = getToolkit().createLabel(detailsClient, "Reenter password*:");
		repasswordLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		repasswordText = getToolkit().createText(detailsClient, "", SWT.PASSWORD);
		repasswordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		repasswordText.addListener(SWT.Modify, modifyListener);
		repasswordText.addListener(SWT.Modify, new Listener() {
			@Override
			public void handleEvent(Event event) {
				if (!StringUtil.isEmpty(repasswordText.getText())) 
					needsSavePassword = true;
			}
		});
	}

	private void createPasswordField(Composite detailsClient) {
		// Password
		Label passwordLabel = getToolkit().createLabel(detailsClient, "Password*:");
		passwordLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		passwordText = getToolkit().createText(detailsClient, "", SWT.PASSWORD);
		passwordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		passwordText.addListener(SWT.Modify, modifyListener);
		passwordText.addListener(SWT.Modify, new Listener() {
			@Override
			public void handleEvent(Event event) {
				if (!StringUtil.isEmpty(passwordText.getText())) 
					needsSavePassword = true;
			}
		});
	}

	protected void createDisabledStateField(Composite detailsClient) {
		// Disabled state
		Composite composite = getToolkit().createComposite(detailsClient);
		composite.setLayoutData(new GridData(SWT.BEGINNING, SWT.BEGINNING, true, false, 2, 1));
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		disabledButton = getToolkit().createButton(composite, "The account is disabled", SWT.CHECK);
		disabledButton.addListener(SWT.Selection, modifyListener);
	}
	
	
	@Override
	protected CompoundCommand buildCommitCommand() {
		CompoundCommand command = super.buildCommitCommand();
		command.append(new SetCommand(editingDomain, getInput(), OmPackage.eINSTANCE.getUser_Login(), loginText.getText()));
		command.append(new SetCommand(editingDomain, getInput(), OmPackage.eINSTANCE.getUser_Disabled(), disabledButton.getSelection()));

		if (needsSavePassword) {
			command.append(new SavePasswordCommand(getInput(), passwordText.getText()));
			needsSavePassword = false;
		}
		
		return command;
	}

	@Override
	public void refresh() {
		super.refresh();
		
		if (getInput() != null) {
			modifyListener.disable();
			loginText.setText(getInput().getLogin() != null ? getInput().getLogin() : "");
			passwordText.setText("");
			repasswordText.setText("");
			disabledButton.setSelection(getInput().isDisabled());
			modifyListener.enable();
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	protected User getInput() {
		return (User) input;
	}
}
