package es.upv.dsic.issi.dplfw.om.presentation.editors.form;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;

import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.presentation.commands.CreateUnitCommand;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
/**
 *
 */
public class UnitsBlock extends ActorBlock {
	
	public UnitsBlock(FormPage page) {
		super(page);
		setText("Organizational units");
		setDescription("An organizational unit allows to classify users in different groups. Organizational units may have sub-units.");
	}


	protected ViewerFilter createViewerFilter() {
		return new ViewerFilter() {
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				return element instanceof Unit;
			}
		};
	}

	@Override
	protected void createMasterPart(IManagedForm managedForm, Composite parent) {
		super.createMasterPart(managedForm, parent);
		this.initContextMenu();
	}
	
	private void initContextMenu() {
		// initalize the context menu
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				Action action = new Action() {
					public void run() {
						IStructuredSelection selection = (IStructuredSelection) actorsViewer.getSelection();
						if (selection.getFirstElement() instanceof Unit) {
							createUnit((Unit) selection.getFirstElement());
						} else {
							createUnit();
						}
					}
				};
				action.setText("New &Child Unit");
				manager.add(action);
			}
		});
		Menu menu = menuMgr.createContextMenu(actorsViewer.getTree());
		actorsViewer.getTree().setMenu(menu);
	}

	@Override
	protected AdapterFactoryContentProvider createViewerContentProvider() {
		return new AdapterFactoryContentProvider(new OmItemProviderAdapterFactory()) {
			@Override
			public boolean hasChildren(Object object) {
				if (object instanceof Unit) {
					return !((Unit) object).getHasUnits().isEmpty();
				}
				return super.hasChildren(object);
			}
		};
	}
	
	protected void registerPages(DetailsPart detailsPart) {
		super.registerPages(detailsPart);
		detailsPart.registerPage(OmFactory.eINSTANCE.createUnit().getClass(), new UnitDetailsPage(editingDomain));
	}
	
	protected void performNew(SelectionEvent e) {
		createUnit(null);
	}


	private void createUnit(Unit parentUnit) {
		CreateUnitCommand command = new CreateUnitCommand(input, parentUnit);
		if (command.canExecute()) {
			editingDomain.getCommandStack().execute(command);
			Unit newUnit = command.getNewUnit();
			actorsViewer.refresh();
			actorsViewer.setSelection(new StructuredSelection(newUnit));
			getManagedForm().dirtyStateChanged();
		}
	}
	
	private void createUnit() {
		createUnit(null);
	}

}