package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Section;

import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.provider.UserItemProvider;

public class UnitDetailsPage extends ActorDetailsPage {


	private final class CustomOmItemProviderAdapterFactory extends OmItemProviderAdapterFactory {
		@Override
		public Adapter createUserAdapter() {
			if (userItemProvider == null) {
				userItemProvider = new UserItemProvider(this) {
					@Override
					public String getText(Object object) {
						String label = super.getText(object);
						if (getInput().getManager() != null && 
								getInput().getManager().equals(object)) {
							return label + " [Manager]";
						} else {
							return label;
						}
					}
				};
			}
			
			return userItemProvider;
		}
	}

	private final class ViewerLabelProvider extends AdapterFactoryLabelProvider implements IFontProvider {
		private ViewerLabelProvider(AdapterFactory adapterFactory) {
			super(adapterFactory);
		}

		@Override
		public Font getFont(Object object) {
			Font font = viewer.getControl().getFont();
			if (getInput().getManager() != null &&
					getInput().getManager().equals(object)) {
				return JFaceResources.getFontRegistry().getBold(font.getFontData()[0].getName());
			} else {
				return font;
			}
		}
	}

	private CheckboxTableViewer viewer;
	private Button setManagerButton;
	private Button selectAllButton;
	private Button selectNoneButton;
	private EContentAdapter organizationChangesAdapter = new EContentAdapter() {
		@Override
		public void notifyChanged(Notification notification) {
			if ((notification.getFeature().equals(OmPackage.eINSTANCE.getOrganization_Users())
					|| notification.getFeature().equals(OmPackage.eINSTANCE.getActor_Name()))
					&& viewer != null 
					&& !viewer.getTable().isDisposed()) {
				viewer.refresh();
			}
		}
	};
	
	
	public UnitDetailsPage(EditingDomain editingDomain) {
		super(editingDomain);
		setText("Unit details");
		setDescription("Set the properties of the selected Unit. Required fields are denoted by \"*\".");
	}

	@Override
	public void createContents(Composite parent) {
		super.createContents(parent);
		
		Section usersSection = getToolkit().createSection(parent, Section.DESCRIPTION|Section.TITLE_BAR);
		usersSection.setText("Organizational Unit Members"); //$NON-NLS-1$
		usersSection.setDescription("Select the members of the Organizational Unit. The User in bold font is the manager."); //$NON-NLS-1$
		usersSection.marginWidth = 10;
		usersSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		Composite usersClient = getToolkit().createComposite(usersSection, SWT.WRAP);
		GridLayout usersGridLayout = new GridLayout();
		usersGridLayout.marginWidth = 0;
		usersGridLayout.marginHeight = 0;
		usersGridLayout.numColumns = 2;
		usersClient.setLayout(usersGridLayout);
		usersClient.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		GridData tablesGridData = new GridData(GridData.FILL_BOTH);
		tablesGridData.heightHint = 20;
		tablesGridData.widthHint = 100;
		
		Table candidatesTable = getToolkit().createTable(usersClient, SWT.SINGLE | SWT.CHECK);
		candidatesTable.setLayoutData(tablesGridData);
		viewer = new CheckboxTableViewer(candidatesTable);
		
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(new ViewerLabelProvider(new CustomOmItemProviderAdapterFactory()));
		
		viewer.setSorter(new ActorViewerSorter());
		
		viewer.setInput(EcoreUtil.getRootContainer(getInput()));
		viewer.setCheckStateProvider(new ICheckStateProvider() {
			@Override
			public boolean isGrayed(Object element) {
				return false;
			}
			
			@Override
			public boolean isChecked(Object element) {
				if (getInput() != null)
					return getInput().getUsers().contains(element);
				else
					return false;
			}
		});
		
		viewer.addCheckStateListener(new ICheckStateListener() {
			@Override
			public void checkStateChanged(CheckStateChangedEvent event) {
				Command command = null;
				if (event.getChecked()) {
					command = AddCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Users(), event.getElement());
				} else {
					command = RemoveCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Users(), event.getElement());
				}
				if (command.canExecute()) {
					markDirty();
					editingDomain.getCommandStack().execute(command);
				}
			}
		});
		
		viewer.getTable().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
				Command command = SetCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Manager(), selection.getFirstElement());
				if (command.canExecute()) {
					markDirty();
					editingDomain.getCommandStack().execute(command);
					viewer.refresh();
				}
			}
		});
		Composite buttonsComposite = getToolkit().createComposite(usersClient);
		GridData layoutData = new GridData(SWT.FILL, SWT.TOP, false, true);
		buttonsComposite.setLayoutData(layoutData);
		buttonsComposite.setLayout(new FillLayout(SWT.VERTICAL));

		setManagerButton = getToolkit().createButton(buttonsComposite, "Set as &Manager", SWT.PUSH);
		setManagerButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
				Command command = SetCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Manager(), selection.getFirstElement());
				if (command.canExecute()) {
					markDirty();
					editingDomain.getCommandStack().execute(command);
					viewer.refresh();
				}
			}
		});
		
		getToolkit().createLabel(buttonsComposite, null);

		selectAllButton = getToolkit().createButton(buttonsComposite, "Select &All", SWT.PUSH);
		selectAllButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Command command = SetCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Users(), viewer.getInput());
				if (command.canExecute()) {
					markDirty();
					editingDomain.getCommandStack().execute(command);
					viewer.refresh();
				}
			}
		});
		
		selectNoneButton = getToolkit().createButton(buttonsComposite, "Select &None", SWT.PUSH);
		selectNoneButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Command command = SetCommand.create(editingDomain, getInput(), OmPackage.eINSTANCE.getUnit_Users(), SetCommand.UNSET_VALUE);
				if (command.canExecute()) {
					markDirty();
					editingDomain.getCommandStack().execute(command);
					viewer.refresh();
				}
			}
		});
		
		getToolkit().paintBordersFor(usersSection);
		usersSection.setClient(usersClient);
		
	}
	
	@Override
	protected void createFields(Composite detailsClient) {
		createUuidField(detailsClient);
		
		createNameField(detailsClient);
	
		createEmailField(detailsClient);
		
		createDescriptionField(detailsClient);

	}

	@Override
	public boolean setFormInput(Object input) {
		super.setFormInput(input);
		Unit unit = (Unit) input;
		Organization organization = (Organization) EcoreUtil.getRootContainer((EObject) input);

		if (!organization.eAdapters().contains(organizationChangesAdapter)) {
			organization.eAdapters().add(organizationChangesAdapter);
		}

		if (unit.getBelongsTo() == null) {
			viewer.setInput(organization.getUsers());
		} else {
			viewer.setInput(unit.getBelongsTo().getUsers());
		}		
		
		return true;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected Unit getInput() {
		return (Unit) input;
	}
}
