package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmPackage;

public abstract class ActorDetailsPage extends AbstractFormPart implements IDetailsPage {

	protected class DisableableListener implements Listener {
		
		private volatile boolean disabled = false;
		
		@Override
		public void handleEvent(Event event) {
			if (!disabled)
				markDirty();
		}
		public void enable() {
			disabled = false;
		}
		public void disable() {
			disabled = true;
		}
	};
	
	protected String text;
	protected String description;
	
	protected Actor input;
	protected EditingDomain editingDomain;
	protected Text uuidText;
	protected Text nameText;
	protected Text emailText;
	protected Text descriptionText;
	
	protected DisableableListener modifyListener = new DisableableListener();

//	private ControlDecoration nameDecoration;
//	private ControlDecoration loginDecoration;
//	private ControlDecoration passwordDecoration;

	
	
	public ActorDetailsPage(EditingDomain editingDomain) {
		this.editingDomain = editingDomain;
	}
	
	@Override
	public void createContents(Composite parent) {
		
		GridLayout layout = new GridLayout();

		layout.marginTop = 0;
		layout.marginLeft = 5;
		layout.marginRight = 2;
		layout.marginBottom = 7;
		layout.verticalSpacing = 15;
		parent.setLayout(layout);
	
		FormToolkit toolkit = getManagedForm().getToolkit();

		Section detailsSection = toolkit.createSection(parent, Section.DESCRIPTION|Section.TITLE_BAR);
		detailsSection.marginWidth = 10;
		detailsSection.setText(text); //$NON-NLS-1$
		detailsSection.setDescription(description);
		detailsSection.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		
		Composite detailsClient = toolkit.createComposite(detailsSection);
		GridLayout detailsGridLayout = new GridLayout();
		detailsGridLayout.marginWidth = 0;
		detailsGridLayout.marginHeight = 0;
		detailsGridLayout.numColumns = 2;
		detailsGridLayout.horizontalSpacing = 14;
		detailsClient.setLayout(detailsGridLayout);

		
		createFields(detailsClient);
//		createDecorators();
		
		toolkit.paintBordersFor(detailsSection);
		detailsSection.setClient(detailsClient);
	}

//	private void createDecorators() {
//		 nameDecoration = createControlDecoration(nameText);
//		 loginDecoration = createControlDecoration(loginText);
//		 passwordDecoration = createControlDecoration(passwordText);
//	}
//	
//	private ControlDecoration createControlDecoration(Control control) {
//		
//		FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR);
//
//		ControlDecoration controlDecoration = new ControlDecoration(control, SWT.LEFT | SWT.TOP);
//		controlDecoration.setImage(errorDecoration.getImage());
//		controlDecoration.setMarginWidth(2);
//		controlDecoration.hide();
//		
//		return controlDecoration;
//	}
	

	protected abstract void createFields(Composite detailsClient);


	protected void createDescriptionField(Composite detailsClient) {
		// Description
		Label descriptionLabel = getToolkit().createLabel(detailsClient, "Description:");
		descriptionLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		descriptionText = getToolkit().createText(detailsClient, "");
		descriptionText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		descriptionText.addListener(SWT.Modify, modifyListener);
	}

	protected void createEmailField(Composite detailsClient) {
		// e-mail
		Label emailLabel = getToolkit().createLabel(detailsClient, "E-mail:");
		emailLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		emailText = getToolkit().createText(detailsClient, "");
		emailText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		emailText.addListener(SWT.Modify, modifyListener);
	}

	protected void createNameField(Composite detailsClient) {
		// Name
		Label nameLabel = getToolkit().createLabel(detailsClient, "Name*:");
		nameLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		nameText = getToolkit().createText(detailsClient, "");
		nameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		nameText.addListener(SWT.Modify, modifyListener);
	}

	protected void createUuidField(Composite detailsClient) {
		// UUID
		Label uuidLabel = getToolkit().createLabel(detailsClient, "UUID:");
		uuidLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		uuidText = getToolkit().createText(detailsClient, "");
		uuidText.setEditable(false);
		uuidText.setEnabled(false);
		uuidText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	}
	
	@Override
	public void commit(boolean onSave) {
		super.commit(onSave);
		CompoundCommand command = buildCommitCommand();
		
		if (command.canExecute()) 
			editingDomain.getCommandStack().execute(command);
	}

	protected CompoundCommand buildCommitCommand() {
		CompoundCommand command = new CompoundCommand();
		
		command.append(new SetCommand(editingDomain, input, OmPackage.eINSTANCE.getActor_Name(), nameText.getText()));
		command.append(new SetCommand(editingDomain, input, OmPackage.eINSTANCE.getActor_Description(), descriptionText.getText()));
		command.append(new SetCommand(editingDomain, input, OmPackage.eINSTANCE.getActor_Email(), emailText.getText()));
		return command;
	}
	
	

	@Override
	public void selectionChanged(IFormPart part, ISelection selection) {
		IStructuredSelection structuredSelection = (IStructuredSelection) selection;
		if (structuredSelection.size() == 1) {
			setFormInput(structuredSelection.getFirstElement());
		}
		else {
			setFormInput(null);
		}
	}

	@Override
	public boolean setFormInput(Object input) {
		if (this.input != input) {
			this.input = (Actor) input;
			refresh();
		}
		return true;
	}
	
	@Override
	public void refresh() {
		if (input != null) {
			modifyListener.disable();

			uuidText.setText(input.getUuid().toString() != null ? input.getUuid().toString() : "");
			nameText.setText(input.getName() != null ? input.getName() : "");
			emailText.setText(input.getEmail() != null ? input.getEmail() : "");
			descriptionText.setText(input.getDescription() != null ? input.getDescription() : "");
			modifyListener.enable();
		}
		super.refresh();
	}

	
	protected FormToolkit getToolkit() {
		return getManagedForm().getToolkit();
	}

	public void setText(String text) {
		this.text = text;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public void setFocus() {
		nameText.setSelection(0, nameText.getCharCount());
		nameText.setFocus();
	}
	protected abstract <T extends Actor> T getInput();
	
	
//	private boolean performValidate() {
//		boolean valid = true;
//		hideDecorations();
//		if (StringUtil.isEmpty(nameText.getText())) {
//			nameDecoration.showHoverText("Name field is required");
//			nameDecoration.show();
//			valid = false;
//		}
//		if (StringUtil.isEmpty(loginText.getText())) { 
//			loginDecoration.showHoverText("Login field is required");
//			loginDecoration.show();
//			valid = false;
//		}
//		if (needsSavePassword && StringUtil.isEmpty(passwordText.getText())) {
//			passwordDecoration.showHoverText("Password cannot be empty");
//			valid = false;
//		}
//		if (passwordText.getText() != repasswordText.getText()) {
//			passwordDecoration.showHoverText("Passwords do not match");
//			valid = false;
//		}
//		return valid;
//	}
//
//	private void hideDecorations() {
//		nameDecoration.hide();
//		loginDecoration.hide();
//		passwordDecoration.hide();
//	}
}
