package es.upv.dsic.issi.dplfw.om.presentation.editors.form;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmPackage;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.presentation.OmEditorPlugin;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;

public abstract class ActorBlock extends MasterDetailsBlock {

	protected FormPage page;
	protected DetailsPart detailsPart;
	protected EditingDomain editingDomain;
	protected TreeViewer actorsViewer;
	protected Organization input;
	protected String text = "";
	protected String description = "";

	public ActorBlock(FormPage page) {
		this.page = page;
		
		Assert.isTrue(page.getEditor() instanceof IEditingDomainProvider);
		editingDomain = ((IEditingDomainProvider) page.getEditor()).getEditingDomain();
		
		Resource res = editingDomain.getResourceSet().getResources().get(0);
		input = (Organization) res.getContents().get(0);
		
		input.eAdapters().add(new EContentAdapter() {
			@Override
			public void notifyChanged(Notification notification) {
				if (notification.getFeature().equals(OmPackage.eINSTANCE.getActor_Name())
						&& actorsViewer != null 
						&& !actorsViewer.getTree().isDisposed()) {
					actorsViewer.update(notification.getNotifier(), null);
				} else if (notification.getEventType() == Notification.ADD
						&& notification.getNewValue() instanceof Actor
						&& !((Actor) notification.getNewValue()).eAdapters().contains(this)) {
					((Actor) notification.getNewValue()).eAdapters().add(this);
				}
			}
		});
	}

	
	protected void createMasterPart(final IManagedForm managedForm, Composite parent) {

		FormToolkit toolkit = getToolkit();
		
		Section section = toolkit.createSection(parent, Section.DESCRIPTION|Section.TITLE_BAR);
		section.setText(text);
		section.setDescription(description); 
		section.marginWidth = 10;
		section.marginHeight = 5;

		
		Composite clientComposite = toolkit.createComposite(section, SWT.WRAP);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = 2;
		layout.marginHeight = 2;
		clientComposite.setLayout(layout);

		final SectionPart spart = new SectionPart(section);
		
		section.setClient(clientComposite);
		
		managedForm.addPart(spart);
		
		Tree tree = toolkit.createTree(clientComposite, SWT.NULL);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.heightHint = 20;
		gridData.widthHint = 100;
		tree.setLayoutData(gridData);
		toolkit.paintBordersFor(clientComposite);
		
		Composite buttonsComposite = toolkit.createComposite(clientComposite);
		GridData layoutData = new GridData(GridData.FILL, GridData.BEGINNING, false, false);
		layoutData.widthHint = 100;
		buttonsComposite.setLayoutData(layoutData);
		buttonsComposite.setLayout(new FillLayout(SWT.VERTICAL));
		
		Button newButton = toolkit.createButton(buttonsComposite, "&New", SWT.PUSH);
		newButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				performNew(e);
				detailsPart.setFocus();
			}
		});
		
		Button deleteButton = toolkit.createButton(buttonsComposite, "&Delete", SWT.PUSH);
		deleteButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				performDelete(e);
			}
		});

		
		actorsViewer = new TreeViewer(tree);
		
		actorsViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				page.getManagedForm().fireSelectionChanged(spart, actorsViewer.getSelection());
			}
		});
		
		actorsViewer.setContentProvider(createViewerContentProvider());
		actorsViewer.setLabelProvider(createViewerLabelProvider());
		actorsViewer.setSorter(new ActorViewerSorter());
		
		Resource res = editingDomain.getResourceSet().getResources().get(0);
		input = (Organization) res.getContents().get(0);
		actorsViewer.setInput(input);
		
		actorsViewer.addFilter(createViewerFilter());
	}


	protected AdapterFactoryLabelProvider createViewerLabelProvider() {
		return new AdapterFactoryLabelProvider(new OmItemProviderAdapterFactory());
	}


	protected AdapterFactoryContentProvider createViewerContentProvider() {
		return new AdapterFactoryContentProvider(new OmItemProviderAdapterFactory());
	}
	
	
	protected void createToolBarActions(IManagedForm managedForm) {
		final ScrolledForm form = managedForm.getForm();
		
		Action haction = new Action("hor", Action.AS_RADIO_BUTTON) { //$NON-NLS-1$
			public void run() {
				sashForm.setOrientation(SWT.HORIZONTAL);
				form.reflow(true);
			}
		};
		
		haction.setChecked(true);
		haction.setToolTipText("Horizontal orientation"); //$NON-NLS-1$
		haction.setImageDescriptor(OmEditorPlugin.getPlugin().getImageRegistry().getDescriptor(OmEditorPlugin.IMG_HORIZONTAL));
		Action vaction = new Action("ver", Action.AS_RADIO_BUTTON) { //$NON-NLS-1$
			public void run() {
				sashForm.setOrientation(SWT.VERTICAL);
				form.reflow(true);
			}
		};
		
		vaction.setChecked(false);
		vaction.setToolTipText("Vertical orientation"); //$NON-NLS-1$
		vaction.setImageDescriptor(OmEditorPlugin.getPlugin().getImageRegistry().getDescriptor(OmEditorPlugin.IMG_VERTICAL));
		form.getToolBarManager().add(haction);
		form.getToolBarManager().add(vaction);
	}


	public void setText(String text) {
		this.text = text;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}

	protected IManagedForm getManagedForm() {
		return page.getManagedForm();
	}
	
	protected FormToolkit getToolkit() {
		return getManagedForm().getToolkit();
	}
	
	protected abstract ViewerFilter createViewerFilter();
	
	protected abstract void performNew(SelectionEvent e);
	
	protected void performDelete(SelectionEvent e) {
		IStructuredSelection selection = (IStructuredSelection) actorsViewer.getSelection();
		Object element = selection.getFirstElement();
		if (element instanceof Actor) {
			Command command = DeleteCommand.create(editingDomain, element);
			if (command.canExecute()) {
				editingDomain.getCommandStack().execute(command);
				actorsViewer.refresh();
				getManagedForm().dirtyStateChanged();
			}
		}
	}
	
	@Override
	protected void registerPages(DetailsPart detailsPart) {
		this.detailsPart = detailsPart;
	}
}