package es.upv.dsic.issi.dplfw.om.presentation.commands;

import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.User;

public class CreateUserCommand extends ChangeCommand {
	
	private Organization organization;
	private User user;
	
	public CreateUserCommand(Organization organization) {
		super(new ChangeRecorder(), organization);
		this.organization = organization;
	}
	
	@Override
	protected void doExecute() {
		user = OmFactory.eINSTANCE.createUser();
		user.createUUID();
		organization.getUsers().add(user);
	}

	public User getNewUser() {
		return user;
	}
}