package es.upv.dsic.issi.dplfw.om.presentation.commands;

import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;

public class CreateUnitCommand extends ChangeCommand {
	
	private Organization organization;
	private Unit parentUnit;
	private Unit unit;
	
	public CreateUnitCommand(Organization organization) {
		this(organization, null);
	}

	public CreateUnitCommand(Organization organization, Unit parentUnit) {
		super(new ChangeRecorder(), organization);
		this.organization = organization;
		this.parentUnit = parentUnit;
	}
	
	@Override
	protected void doExecute() {
		unit = OmFactory.eINSTANCE.createUnit();
		unit.createUUID();
		if (parentUnit != null) {
			parentUnit.getHasUnits().add(unit);
		} else {
			organization.getUnits().add(unit);
		}
	}

	public Unit getNewUnit() {
		return unit;
	}
}