/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.om.presentation;

import java.net.URL;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import es.upv.dsic.issi.dplfw.datatypes.provider.DatatypesEditPlugin;

/**
 * This is the central singleton for the Om editor plugin.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public final class OmEditorPlugin extends EMFPlugin {

	
	public static final String IMG_HORIZONTAL = "horizontal"; //$NON-NLS-1$
	public static final String IMG_VERTICAL = "vertical"; //$NON-NLS-1$

	/**
	 * Keep track of the singleton.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final OmEditorPlugin INSTANCE = new OmEditorPlugin();
	
	/**
	 * Keep track of the singleton.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Implementation plugin;

	/**
	 * Create the instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OmEditorPlugin() {
		super
			(new ResourceLocator [] {
				DatatypesEditPlugin.INSTANCE,
			});
	}

	/**
	 * Returns the singleton instance of the Eclipse plugin.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the singleton instance.
	 * @generated
	 */
	@Override
	public ResourceLocator getPluginResourceLocator() {
		return plugin;
	}

	/**
	 * Returns the singleton instance of the Eclipse plugin.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the singleton instance.
	 * @generated
	 */
	public static Implementation getPlugin() {
		return plugin;
	}
	
	/**
	 * The actual implementation of the Eclipse <b>Plugin</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class Implementation extends EclipseUIPlugin {
		/**
		 * Creates an instance.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Implementation() {
			super();
	
			// Remember the static instance.
			//
			plugin = this;
		}
		
		protected void initializeImageRegistry(ImageRegistry registry) {
			registerImage(registry, IMG_HORIZONTAL, "elcl16/th_horizontal.gif"); //$NON-NLS-1$
			registerImage(registry, IMG_VERTICAL, "elcl16/th_vertical.gif"); //$NON-NLS-1$
		}

		private void registerImage(ImageRegistry registry, String key, String fileName) {
			try {
				IPath path = new Path("icons/full/" + fileName); //$NON-NLS-1$
				URL url = find(path);
				if (url!=null) {
					ImageDescriptor desc = ImageDescriptor.createFromURL(url);
					registry.put(key, desc);
				}
			} catch (Exception e) {
			}
		}
		
		public Image getImage(String key) {
			return getImageRegistry().get(key);
		}
		
		public ImageDescriptor getImageDescriptor(String key) {
			return getImageRegistry().getDescriptor(key);
		}
	}

}
