/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager.internal;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.InvalidLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.NullLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UninitializedLocationException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class LocalFileCredentialsManager
implements ICredentialsManager {
    private java.net.URI location;
    private Organization organization;
    private Resource resource;

    @Override
    public void setLocation(java.net.URI uri) throws InvalidLocationException {
        if (uri != null) {
            this.location = uri;
            if (!this.fileExists()) {
                throw new InvalidLocationException(uri);
            }
        } else {
            this.location = CredentialsManagerPlugin.getDefault().getStateLocation().append("localcredentials.om").toFile().toURI();
        }
    }

    @Override
    public void loadLocation() throws NullLocationException, UninitializedLocationException, IOException {
        if (this.location == null) {
            throw new NullLocationException();
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.fileExists()) {
            this.resource = resourceSet.getResource(URI.createURI((String)this.location.toString()), true);
        }
        this.resource.load(Collections.emptyMap());
        if (this.resource.getContents().isEmpty() || !(this.resource.getContents().get(0) instanceof Organization)) {
            throw new UninitializedLocationException(this.location);
        }
        this.organization = (Organization)this.resource.getContents().get(0);
    }

    @Override
    public void initializeLocation() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.fileExists()) {
            this.resource = resourceSet.getResource(URI.createURI((String)this.location.toString()), true);
            this.resource.load(Collections.emptyMap());
        } else {
            this.resource = resourceSet.createResource(URI.createURI((String)this.location.toString()));
        }
        if (!this.resource.getContents().isEmpty()) {
            this.resource.getContents().clear();
        }
        this.organization = OmFactory.eINSTANCE.createOrganization();
        this.resource.getContents().add((Object)this.organization);
        this.resource.save(Collections.emptyMap());
    }

    private boolean fileExists() {
        File file = new File(this.location);
        return file.exists();
    }

    protected User getUser(UUID uuid) {
        return (User)this.resolveActor(uuid);
    }

    @Override
    public boolean isValidCredential(UUID uuid, String password) {
        return this.isValidCredential(this.getUser(uuid), password);
    }

    @Override
    public boolean isValidCredential(User user, String password) {
        return user.isValidPassword(password);
    }

    @Override
    public String resolveActorName(UUID uuid) {
        if (this.resolveActor(uuid) == null) {
            return null;
        }
        return this.resolveActor(uuid).getName();
    }

    @Override
    public java.net.URI getLocation() {
        return this.location;
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public Actor resolveActor(UUID uuid) {
        EObject eObject;
        if (uuid != null && (eObject = this.resource.getEObject(uuid.toString())) instanceof Actor) {
            return (Actor)eObject;
        }
        return null;
    }

    @Override
    public User resolveUser(String login) {
        for (User user : this.getOrganization().getUsers()) {
            if (!user.getLogin().equals(login)) continue;
            return user;
        }
        return null;
    }

    @Override
    public boolean isIncluded(Actor actor1, Actor actor2) {
        Unit unit;
        if (actor1 == null || actor2 == null) {
            return false;
        }
        if (actor1.getUuid().equals(actor2.getUuid())) {
            return true;
        }
        return actor2 instanceof Unit && (unit = (Unit)actor2).getUsers().contains((Object)actor1);
    }
}

