/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.OmFactory;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerType;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.InvalidLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.NullLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UninitializedLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UnknownCredentialsManagerType;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CredentialsManagersRegistry {
    private static final String PREF_NODE_REGISTERED_MANAGERS = "PREF_NODE_REGISTERED_MANAGERS";
    private static final String PREF_ACTIVE_MANAGER_TYPE = "PREF_ACTIVE_MANAGER_TYPE";
    private static final String PREF_ACTIVE_MANAGER_LOCATION = "PREF_ACTIVE_MANAGER_LOCATION";
    public static CredentialsManagersRegistry eINSTANCE;
    private List<CredentialsManagerType> registeredTypes;
    private ConcurrentHashMap<String, ICredentialsManager> registeredManagers;
    private ICredentialsManager activeManager = null;

    public CredentialsManagersRegistry() throws CoreException, BackingStoreException, InvalidLocationException, URISyntaxException, UnknownCredentialsManagerType, NullLocationException, IOException, UninitializedLocationException {
        eINSTANCE = this;
        this.loadRegisteredTypes();
        this.loadRegisteredManagers();
        this.loadActiveManager();
    }

    private void loadRegisteredTypes() throws CoreException {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("es.upv.dsic.issi.dplfw.om.credentialsmanager");
        this.registeredTypes = new ArrayList<CredentialsManagerType>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.registeredTypes.add(new CredentialsManagerType(element));
            ++n2;
        }
    }

    private void loadRegisteredManagers() throws BackingStoreException, URISyntaxException, UnknownCredentialsManagerType, CoreException, NullLocationException, IOException {
        Preferences topNode = this.getPreferencesNode();
        this.registeredManagers = new ConcurrentHashMap();
        String[] stringArray = topNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            String[] stringArray2 = topNode.node(typeId).keys();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String location = stringArray2[n4];
                try {
                    this.registeredManagers.put(topNode.node(typeId) + location, this.createManager(typeId, new URI(location)));
                }
                catch (InvalidLocationException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void loadActiveManager() throws NullLocationException, UninitializedLocationException, IOException {
        Preferences node = this.getPreferencesNode();
        String type = node.get(PREF_ACTIVE_MANAGER_TYPE, "");
        String location = node.get(PREF_ACTIVE_MANAGER_LOCATION, "");
        if (type != null && location != null) {
            Preferences typeNode = this.getPreferencesNode().node(type);
            this.activeManager = this.registeredManagers.get(String.valueOf(typeNode.absolutePath()) + location);
        } else {
            ICredentialsManager manager = this.getPriorityManager();
            if (manager != null) {
                try {
                    this.setActiveManager(manager);
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            this.activeManager = manager;
        }
        if (this.activeManager == null) {
            this.activeManager = new DummyCredentialsManager();
        }
        this.activeManager.loadLocation();
    }

    public CredentialsManagerType getManagerTypeFor(ICredentialsManager manager) {
        if (manager == null) {
            return null;
        }
        for (CredentialsManagerType type : this.registeredTypes) {
            if (!type.getManagerClassName().equals(manager.getClass().getName())) continue;
            return type;
        }
        return null;
    }

    public List<CredentialsManagerType> getManagerTypes() {
        return this.registeredTypes;
    }

    public Collection<ICredentialsManager> getManagers() {
        return this.registeredManagers.values();
    }

    public ICredentialsManager createManager(String typeId, URI uri) throws CoreException, InvalidLocationException, UnknownCredentialsManagerType {
        if (this.findType(typeId) == null) {
            throw new UnknownCredentialsManagerType(typeId);
        }
        CredentialsManagerType type = this.findType(typeId);
        ICredentialsManager manager = type.createCredentialsManager();
        manager.setLocation(uri);
        return manager;
    }

    public void setActiveManager(String typeId, URI uri) throws BackingStoreException, NullLocationException, UninitializedLocationException, IOException {
        Preferences node = this.getPreferencesNode();
        if (typeId != null) {
            node.put(PREF_ACTIVE_MANAGER_TYPE, typeId);
        } else {
            node.remove(PREF_ACTIVE_MANAGER_TYPE);
        }
        if (uri != null) {
            node.put(PREF_ACTIVE_MANAGER_LOCATION, uri.toString());
        } else {
            node.remove(PREF_ACTIVE_MANAGER_LOCATION);
        }
        node.flush();
        this.loadActiveManager();
    }

    public void setActiveManager(ICredentialsManager manager) throws BackingStoreException, NullLocationException, UninitializedLocationException, IOException {
        CredentialsManagerType type = this.getManagerTypeFor(manager);
        String typeId = type != null ? type.getId() : null;
        URI location = manager != null ? manager.getLocation() : null;
        this.setActiveManager(typeId, location);
    }

    public ICredentialsManager getActiveManager() {
        return this.activeManager;
    }

    public void registerManager(ICredentialsManager manager) throws BackingStoreException {
        String typeId = this.getManagerTypeFor(manager).getId();
        URI uri = manager.getLocation();
        Preferences node = this.getPreferencesNode().node(typeId);
        String location = uri.toString();
        node.put(location, location);
        this.registeredManagers.put(String.valueOf(node.absolutePath()) + location, manager);
        node.flush();
    }

    public void registerManager(String typeId, URI uri) throws BackingStoreException, CoreException, InvalidLocationException, UnknownCredentialsManagerType {
        this.registerManager(this.createManager(typeId, uri));
    }

    public void unregisterManager(ICredentialsManager manager) throws BackingStoreException {
        String typeId = this.getManagerTypeFor(manager).getId();
        this.unregisterManager(typeId, manager.getLocation());
    }

    public void unregisterManager(String typeId, URI uri) throws BackingStoreException {
        Preferences node = this.getPreferencesNode().node(typeId);
        String location = uri.toString();
        node.remove(location);
        this.registeredManagers.remove(String.valueOf(node.absolutePath()) + location);
        node.flush();
    }

    private Preferences getPreferencesNode() {
        return CredentialsManagerPlugin.getPreferences().node(PREF_NODE_REGISTERED_MANAGERS);
    }

    private CredentialsManagerType findType(String id) {
        for (CredentialsManagerType type : this.registeredTypes) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return null;
    }

    private ICredentialsManager getPriorityManager() {
        ICredentialsManager priorityManager = null;
        int lastPriority = Integer.MIN_VALUE;
        for (ICredentialsManager manager : this.registeredManagers.values()) {
            if (this.getManagerTypeFor(manager).getPriority() <= lastPriority) continue;
            priorityManager = manager;
        }
        return priorityManager;
    }

    class DummyCredentialsManager
    implements ICredentialsManager {
        private Organization organization = OmFactory.eINSTANCE.createOrganization();

        DummyCredentialsManager() {
        }

        @Override
        public void setLocation(URI uri) throws InvalidLocationException {
        }

        @Override
        public URI getLocation() {
            return null;
        }

        @Override
        public void loadLocation() throws NullLocationException, UninitializedLocationException, IOException {
        }

        @Override
        public void initializeLocation() throws IOException {
        }

        @Override
        public boolean isValidCredential(UUID uuid, String password) {
            return false;
        }

        @Override
        public boolean isValidCredential(User user, String password) {
            return false;
        }

        @Override
        public String resolveActorName(UUID uuid) {
            if (uuid == null) {
                return null;
            }
            return uuid.toString();
        }

        @Override
        public Organization getOrganization() {
            return this.organization;
        }

        @Override
        public Actor resolveActor(UUID uuid) {
            return null;
        }

        @Override
        public User resolveUser(String login) {
            return null;
        }

        @Override
        public boolean isIncluded(Actor actor1, Actor actor2) {
            return false;
        }
    }
}

