/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager;

import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagersRegistry;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ILoginProvider;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.CancelledLoginException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class CredentialsManagerPlugin
extends Plugin {
    public static final String CREDENTIALS_MANAGER_EXT_ID = "es.upv.dsic.issi.dplfw.om.credentialsmanager";
    public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_ID = "id";
    public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_NAME = "name";
    public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_CLASS = "class";
    public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_PRIORITY = "priority";
    private static CredentialsManagerPlugin plugin;
    private CredentialsManagersRegistry managersRegistry;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.managersRegistry = new CredentialsManagersRegistry();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.managersRegistry = null;
        plugin = null;
        super.stop(bundleContext);
    }

    public static CredentialsManagerPlugin getDefault() {
        return plugin;
    }

    public static Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(plugin.getBundle().getSymbolicName());
    }

    public CredentialsManagersRegistry getManagersRegistry() {
        return this.managersRegistry;
    }

    public User requestLoggedUser(ILoginProvider loginDialog) throws CancelledLoginException {
        String password;
        String login;
        User user;
        ICredentialsManager manager = this.getManagersRegistry().getActiveManager();
        boolean valid = false;
        do {
            loginDialog.requestCredentials();
            login = loginDialog.getLogin();
            password = loginDialog.getPassword();
        } while (!(valid = (user = manager.resolveUser(login)) != null ? manager.isValidCredential(user, password) : false));
        return user;
    }
}

