package es.upv.dsic.issi.dplfw.om.credentialsmanager;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.InvalidLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.NullLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UninitializedLocationException;

public interface ICredentialsManager {
	
	public void setLocation(URI uri) throws InvalidLocationException;

	public URI getLocation();

	public void loadLocation() throws NullLocationException, UninitializedLocationException, IOException; 
	
	public void initializeLocation() throws IOException;
	
	public boolean isValidCredential(UUID uuid, String password);

	public boolean isValidCredential(User user, String password);

	public String resolveActorName(UUID uuid);

	public Organization getOrganization();

	public Actor resolveActor(UUID uuid);

	public User resolveUser(String login);

	/**
	 * Returns whether actor1 is included in actor2
	 * @param actor1
	 * @param actor2
	 * @return
	 */
	public boolean isIncluded(Actor actor1, Actor actor2);


	/*
	public List<Unit> getOrganizationalUnits();
	
	public List<User> getUsers();
	
	public User getUser(String uuid);
	
	public Unit getUnit(String uuid);
	
	public Actor getActor(String uuid);
	*/
	
}
