package es.upv.dsic.issi.dplfw.om.credentialsmanager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class CredentialsManagerType {

	private IConfigurationElement configurationElement;

	CredentialsManagerType(IConfigurationElement configurationElement) {
		this.configurationElement = configurationElement;
	}
	
	public String getName() {
		return configurationElement.getAttribute(
				CredentialsManagerPlugin.CREDENTIALS_MANAGER_EXT_ID_ATT_NAME);
	}
	
	public String getId() {
		return configurationElement.getAttribute(
				CredentialsManagerPlugin.CREDENTIALS_MANAGER_EXT_ID_ATT_ID);
	}
	
	public int getPriority() {
		return Integer.valueOf(configurationElement.getAttribute(
				CredentialsManagerPlugin.CREDENTIALS_MANAGER_EXT_ID_ATT_PRIORITY));
	}

	public String getManagerClassName() {
		return configurationElement.getAttribute(
				CredentialsManagerPlugin.CREDENTIALS_MANAGER_EXT_ID_ATT_CLASS);
	}
	
	public ICredentialsManager createCredentialsManager() throws CoreException {
		return (ICredentialsManager) configurationElement.createExecutableExtension(
				CredentialsManagerPlugin.CREDENTIALS_MANAGER_EXT_ID_ATT_CLASS);
	}
}
