package es.upv.dsic.issi.dplfw.om.credentialsmanager;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.CancelledLoginException;

public class CredentialsManagerPlugin extends Plugin {

	public static final String CREDENTIALS_MANAGER_EXT_ID = "es.upv.dsic.issi.dplfw.om.credentialsmanager";
	public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_ID = "id";
	public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_NAME = "name";
	public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_CLASS = "class";
	public static final String CREDENTIALS_MANAGER_EXT_ID_ATT_PRIORITY = "priority";
	
	private static CredentialsManagerPlugin plugin;
	
	private CredentialsManagersRegistry managersRegistry;

	public void start(BundleContext bundleContext) throws Exception {
		super.start(bundleContext);
		plugin = this;
		managersRegistry = new CredentialsManagersRegistry();
	}

	public void stop(BundleContext bundleContext) throws Exception {
		managersRegistry = null;
		plugin = null;
		super.stop(bundleContext);
	}

	
	public static CredentialsManagerPlugin getDefault() {
		return plugin;
	}

	public static Preferences getPreferences() {
    	return InstanceScope.INSTANCE.getNode(plugin.getBundle().getSymbolicName());
    }
	
	public CredentialsManagersRegistry getManagersRegistry() {
		return managersRegistry;
	}

	public User requestLoggedUser(ILoginProvider loginDialog) throws CancelledLoginException {
		ICredentialsManager manager = getManagersRegistry().getActiveManager();

		boolean valid = false;
		User user;
		
		do {
			loginDialog.requestCredentials();
			
			String login = loginDialog.getLogin();
			String password = loginDialog.getPassword();
		
			user = manager.resolveUser(login);
			if (user != null) { 
				valid = manager.isValidCredential(user, password);
			} else {
				valid = false;
			}
		} while (!valid);
		
		return user;
	}
	
}
