/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards.RegisterNewManagerWizardValues;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetLocationWizardPage
extends WizardPage {
    private RegisterNewManagerWizardValues values;
    private Text locationText;

    public SetLocationWizardPage(RegisterNewManagerWizardValues values) {
        super("SetLocationWizardPage");
        this.setTitle("Set Location");
        this.setDescription("Set the location of the Credentials Manager");
        this.setPageComplete(false);
        this.values = values;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Location:");
        this.locationText = new Text(composite, 2048);
        IPath location = CredentialsManagerPlugin.getDefault().getStateLocation().append("organization.om");
        GridData layoutData = new GridData(4, 0, true, false);
        layoutData.widthHint = 400;
        this.locationText.setLayoutData((Object)layoutData);
        this.addListeners();
        this.locationText.setText(location.toFile().toURI().toString());
    }

    private void addListeners() {
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    URI uri = new URI(SetLocationWizardPage.this.locationText.getText());
                    SetLocationWizardPage.this.values.setLocation(uri);
                    SetLocationWizardPage.this.setErrorMessage(null);
                    SetLocationWizardPage.this.setPageComplete(true);
                }
                catch (URISyntaxException e1) {
                    SetLocationWizardPage.this.setErrorMessage("Invalid location");
                }
            }
        });
    }
}

