/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerType;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards.RegisterNewManagerWizardValues;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectTypeWizardPage
extends WizardPage {
    private TableViewer viewer;
    private RegisterNewManagerWizardValues values;

    public SelectTypeWizardPage(RegisterNewManagerWizardValues values) {
        super("SelectRepositoryWizardPage");
        this.setTitle("Select Credentials Manager Type");
        this.setDescription("Select a Credentials Manager Type");
        this.setPageComplete(false);
        this.values = values;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.viewer = new TableViewer(composite, 2052);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypes());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CredentialsManagerType) {
                    CredentialsManagerType cm = (CredentialsManagerType)element;
                    return String.format("%s (%s)", cm.getName(), cm.getId());
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return CredentialsManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_UNKNOWN_CM");
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListeners();
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectTypeWizardPage.this.getSelectedType() != null) {
                    SelectTypeWizardPage.this.values.setType(SelectTypeWizardPage.this.getSelectedType());
                    SelectTypeWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectTypeWizardPage.this.getContainer().showPage(SelectTypeWizardPage.this.getNextPage());
            }
        });
    }

    public CredentialsManagerType getSelectedType() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (CredentialsManagerType)selection.getFirstElement();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.viewer.setInput((Object)CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypes());
            this.viewer.refresh();
        }
    }
}

