/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.preferences;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerType;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.InvalidLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.NullLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UninitializedLocationException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.UnknownCredentialsManagerType;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards.RegisterNewManagerWizard;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards.RegisterNewManagerWizardValues;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

public class CredentialsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer managersViewer;
    private Button addManagerButton;
    private Button removeManagerButton;
    private Button editManagerButton;
    private List<ICredentialsManager> managers;
    private ComboViewer comboViewer;

    public CredentialsPreferencePage() {
        this.setDescription("Available credential managers");
        this.loadRegisteredManagers();
    }

    private void loadRegisteredManagers() {
        this.managers = new ArrayList<ICredentialsManager>();
        this.managers.addAll(CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagers());
    }

    protected Control createContents(Composite parent) {
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.minimumHeight = 200;
        layoutData.heightHint = 200;
        layoutData.widthHint = 500;
        layoutData.minimumWidth = 400;
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayoutData((Object)layoutData);
        topComposite.setLayout((Layout)topLayout);
        Label activeLabel = new Label(topComposite, 0);
        activeLabel.setText("&Active Manager:");
        activeLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.comboViewer = new ComboViewer(topComposite, 2060);
        GridData comboLayoutData = new GridData(4, 1, true, false, 2, 1);
        comboLayoutData.widthHint = 400;
        this.comboViewer.getControl().setLayoutData((Object)comboLayoutData);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new CmsLabelProvider());
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setInput(this.managers);
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager()));
        Label availableManagersLabel = new Label(topComposite, 0);
        availableManagersLabel.setText("Available Managers:");
        availableManagersLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.managersViewer = new TableViewer(topComposite, 67588);
        this.managersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.managersViewer.setLabelProvider((IBaseLabelProvider)new CmsLabelProvider());
        this.managersViewer.setInput(this.managers);
        this.managersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CredentialsPreferencePage.this.removeManagerButton.setEnabled(!event.getSelection().isEmpty());
                CredentialsPreferencePage.this.editManagerButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        GridData viewerLayoutData = new GridData(4, 4, true, true);
        viewerLayoutData.widthHint = 400;
        this.managersViewer.getControl().setLayoutData((Object)viewerLayoutData);
        Composite buttonsComposite = new Composite(topComposite, 0);
        GridData gridData = new GridData(100, -1);
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 1;
        buttonsComposite.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)fillLayout);
        this.addManagerButton = new Button(buttonsComposite, 8);
        this.addManagerButton.setText("&Add...");
        this.addManagerButton.addSelectionListener((SelectionListener)new AddManagerAdapter());
        this.removeManagerButton = new Button(buttonsComposite, 8);
        this.removeManagerButton.setText("&Remove");
        this.removeManagerButton.addSelectionListener((SelectionListener)new RemoveManagerAdapter());
        this.removeManagerButton.setEnabled(false);
        Label separator = new Label(buttonsComposite, 0);
        this.editManagerButton = new Button(buttonsComposite, 8);
        this.editManagerButton.setText("&Open in Editor");
        this.editManagerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CredentialsPreferencePage.this.managersViewer.getSelection();
                ICredentialsManager manager = (ICredentialsManager)selection.getFirstElement();
                URI uri = manager.getLocation();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(new File(uri).toString()));
                if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e1) {
                        CredentialsPreferencePage.this.logException((Exception)((Object)e1));
                    }
                }
            }
        });
        this.editManagerButton.setEnabled(false);
        return topComposite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.loadRegisteredManagers();
    }

    public boolean performOk() {
        CredentialsManagerType type;
        boolean returnValue = true;
        ArrayList currentManagers = new ArrayList();
        currentManagers.addAll(CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagers());
        for (ICredentialsManager currentManager : currentManagers) {
            if (this.managers.contains(currentManager)) continue;
            type = CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypeFor(currentManager);
            try {
                CredentialsManagerPlugin.getDefault().getManagersRegistry().unregisterManager(type.getId(), currentManager.getLocation());
            }
            catch (BackingStoreException e) {
                this.logException((Exception)((Object)e));
                returnValue = false;
            }
        }
        for (ICredentialsManager manager : this.managers) {
            type = CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypeFor(manager);
            try {
                CredentialsManagerPlugin.getDefault().getManagersRegistry().registerManager(type.getId(), manager.getLocation());
            }
            catch (CoreException e) {
                this.logException((Exception)((Object)e));
                returnValue = false;
            }
            catch (InvalidLocationException e) {
                this.logException((Exception)((Object)e));
                returnValue = false;
            }
            catch (UnknownCredentialsManagerType e) {
                this.logException((Exception)((Object)e));
                returnValue = false;
            }
            catch (BackingStoreException e) {
                this.logException((Exception)((Object)e));
                returnValue = false;
            }
        }
        IStructuredSelection activeManagerSelection = (IStructuredSelection)this.comboViewer.getSelection();
        try {
            CredentialsManagerPlugin.getDefault().getManagersRegistry().setActiveManager((ICredentialsManager)activeManagerSelection.getFirstElement());
        }
        catch (BackingStoreException e) {
            this.logException((Exception)((Object)e));
            returnValue = false;
        }
        catch (NullLocationException e) {
            this.logException((Exception)((Object)e));
            returnValue = false;
        }
        catch (UninitializedLocationException e) {
            this.logException((Exception)((Object)e));
            returnValue = false;
        }
        catch (IOException e) {
            this.logException(e);
            returnValue = false;
        }
        return returnValue;
    }

    void logException(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "es.upv.dsic.issi.dplfw.om.credentialsmanager.ui", e.getLocalizedMessage(), (Throwable)e), 5);
    }

    private final class AddManagerAdapter
    extends SelectionAdapter {
        private AddManagerAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            RegisterNewManagerWizard wizard = new RegisterNewManagerWizard();
            WizardDialog wizardDialog = new WizardDialog(CredentialsPreferencePage.this.getControl().getShell(), (IWizard)wizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            if (wizardDialog.open() == 0) {
                RegisterNewManagerWizardValues values = wizard.getReturnValues();
                ICredentialsManager manager = null;
                try {
                    manager = values.getType().createCredentialsManager();
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                try {
                    manager.setLocation(values.getLocation());
                    CredentialsPreferencePage.this.managers.add(manager);
                }
                catch (InvalidLocationException e1) {
                    try {
                        manager.initializeLocation();
                        CredentialsPreferencePage.this.managers.add(manager);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                CredentialsPreferencePage.this.managersViewer.refresh();
                CredentialsPreferencePage.this.comboViewer.refresh();
            }
        }
    }

    private final class CmsLabelProvider
    extends LabelProvider {
        private CmsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICredentialsManager) {
                ICredentialsManager manager = (ICredentialsManager)element;
                return String.format("%s (Location: %s)", CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypeFor(manager).getName(), manager.getLocation().toString());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return CredentialsManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_UNKNOWN_CM");
        }
    }

    private final class RemoveManagerAdapter
    extends SelectionAdapter {
        private RemoveManagerAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)CredentialsPreferencePage.this.managersViewer.getSelection();
            CredentialsPreferencePage.this.managers.remove(selection.getFirstElement());
            CredentialsPreferencePage.this.managersViewer.refresh();
            CredentialsPreferencePage.this.comboViewer.refresh();
        }
    }
}

