/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.provider.UserItemProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SearchActorsDialog
extends Dialog {
    private int style;
    private TreeViewer availableViewer;
    private TableViewer selectedViewer;
    private Organization organization;
    private ShowOptions showOptions = ShowOptions.UNITS_WITH_USERS;
    private Set<Actor> selectedActors = new LinkedHashSet<Actor>();
    private ICredentialsManager credentialsManager;

    public SearchActorsDialog(Shell parentShell, int style) {
        super(parentShell);
        this.setShellStyle(66608);
        this.credentialsManager = CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
        this.organization = this.credentialsManager.getOrganization();
        this.style = style;
    }

    public SearchActorsDialog(Shell parentShell, List<UUID> initialUuids, int style) {
        this(parentShell, style);
        for (UUID uuid : initialUuids) {
            Actor resolveActor;
            if (uuid == null || (resolveActor = this.credentialsManager.resolveActor(uuid)) == null) continue;
            this.selectedActors.add(resolveActor);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.allowSelectMultipleActors()) {
            newShell.setText("Select Actors");
        } else {
            newShell.setText("Select Actor");
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData dummyLayoutData;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = (GridLayout)container.getLayout();
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        gl_container.horizontalSpacing = 0;
        gl_container.verticalSpacing = 5;
        SashForm contentComposite = null;
        if (this.allowSelectMultipleActors()) {
            contentComposite = new SashForm(container, 512);
            contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        } else {
            contentComposite = new Composite(container, 0);
            contentComposite.setLayout((Layout)new GridLayout(1, false));
            contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        }
        Composite topComposite = new Composite((Composite)contentComposite, 0);
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_topComposite = new GridLayout(1, false);
        gl_topComposite.marginBottom = 5;
        gl_topComposite.marginTop = 13;
        gl_topComposite.marginWidth = 11;
        gl_topComposite.marginHeight = 0;
        topComposite.setLayout((Layout)gl_topComposite);
        Group selectorGroup = new Group(topComposite, 0);
        selectorGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        selectorGroup.setText("Options");
        GridLayout gl_selectorGroup = new GridLayout(3, false);
        selectorGroup.setLayout((Layout)gl_selectorGroup);
        Button usersButton = new Button((Composite)selectorGroup, 16);
        usersButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        usersButton.setText("Show Use&rs");
        usersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchActorsDialog.this.showOptions = ShowOptions.USERS;
                SearchActorsDialog.this.availableViewer.refresh();
            }
        });
        Button unitsButton = new Button((Composite)selectorGroup, 16);
        unitsButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        unitsButton.setText("Show Uni&ts");
        unitsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchActorsDialog.this.showOptions = ShowOptions.UNITS;
                SearchActorsDialog.this.availableViewer.refresh();
            }
        });
        Button unitsWithUsersButton = new Button((Composite)selectorGroup, 16);
        unitsWithUsersButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        unitsWithUsersButton.setText("Show Units &with Users");
        unitsWithUsersButton.setSelection(true);
        unitsWithUsersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchActorsDialog.this.showOptions = ShowOptions.UNITS_WITH_USERS;
                SearchActorsDialog.this.availableViewer.refresh();
            }
        });
        Group resultsGroup = new Group(topComposite, 0);
        resultsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        resultsGroup.setText("Available actors");
        GridLayout gl_resultsGroup = new GridLayout(2, false);
        resultsGroup.setLayout((Layout)gl_resultsGroup);
        OptionsPatternFilter patternFilter = new OptionsPatternFilter();
        OptionsViewerFilter optionsFilter = new OptionsViewerFilter();
        FilteredTree resultsTree = new FilteredTree((Composite)resultsGroup, this.style | 0x100 | 0x200 | 0x800, (PatternFilter)patternFilter, true);
        this.availableViewer = resultsTree.getViewer();
        this.availableViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.availableViewer.setContentProvider((IContentProvider)new CustomAdapterFactoryContentProvider((AdapterFactory)new CustomOmItemProviderAdapterFactory()));
        this.availableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new CustomOmItemProviderAdapterFactory()));
        this.availableViewer.setInput((Object)this.organization);
        this.availableViewer.setFilters(new ViewerFilter[]{optionsFilter, patternFilter});
        this.availableViewer.expandToLevel(-1);
        this.availableViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SearchActorsDialog.this.addActorsToSelection();
            }
        });
        Button addButton = new Button((Composite)resultsGroup, 0);
        GridData gd_addButton = new GridData(16384, 128, false, false, 1, 1);
        gd_addButton.widthHint = 120;
        addButton.setLayoutData((Object)gd_addButton);
        addButton.setText("Select");
        addButton.setImage(CredentialsManagerUIPlugin.getDefault().getImageRegistry().get("IMG_TOOL16_DOWN_ARROW "));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchActorsDialog.this.addActorsToSelection();
            }
        });
        Composite bottomComposite = new Composite((Composite)contentComposite, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout gl_bottomComposite = new GridLayout(1, false);
        gl_bottomComposite.marginHeight = 0;
        gl_bottomComposite.marginBottom = 13;
        gl_bottomComposite.marginWidth = 11;
        bottomComposite.setLayout((Layout)gl_bottomComposite);
        Group selectedActorsGroup = new Group(bottomComposite, 0);
        selectedActorsGroup.setLayout((Layout)new GridLayout(2, false));
        selectedActorsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.allowSelectMultipleActors()) {
            selectedActorsGroup.setText("Selected actors");
        } else {
            selectedActorsGroup.setText("Selected actor");
        }
        Composite dummyComposite = new Composite((Composite)selectedActorsGroup, 0);
        dummyComposite.setLayout((Layout)new FillLayout(768));
        this.selectedViewer = new TableViewer(dummyComposite, 0x10800 | this.style);
        if (this.allowSelectMultipleActors()) {
            dummyLayoutData = new GridData(4, 4, true, true, 1, 1);
            dummyComposite.setLayoutData((Object)dummyLayoutData);
        } else {
            dummyLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
            dummyComposite.setLayoutData((Object)dummyLayoutData);
            dummyLayoutData.heightHint = this.selectedViewer.getTable().getItemHeight() + 2 * this.selectedViewer.getTable().getBorderWidth();
        }
        this.selectedViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new CustomOmItemProviderAdapterFactory()));
        this.selectedViewer.setInput(this.selectedActors);
        Button removeButton = new Button((Composite)selectedActorsGroup, 0);
        removeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        GridData gd_removeButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_removeButton.widthHint = 120;
        removeButton.setLayoutData((Object)gd_removeButton);
        removeButton.setText("Unselect");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchActorsDialog.this.removeActorsFromSelection();
            }
        });
        if (this.allowSelectMultipleActors()) {
            contentComposite.setWeights(new int[]{3, 2});
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(600, 700);
    }

    public Collection<Actor> getActors() {
        return this.selectedActors;
    }

    private void addActorsToSelection() {
        if (!this.allowSelectMultipleActors()) {
            this.selectedActors.clear();
        }
        IStructuredSelection selection = (IStructuredSelection)this.availableViewer.getSelection();
        this.selectedActors.addAll(selection.toList());
        this.selectedViewer.refresh();
        this.selectedViewer.setSelection((ISelection)selection);
    }

    private void removeActorsFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedViewer.getSelection();
        this.selectedActors.removeAll(selection.toList());
        this.selectedViewer.refresh();
        this.availableViewer.setSelection((ISelection)selection);
    }

    private boolean allowSelectMultipleActors() {
        return (this.style & 2) == 2 && (this.style & 4) != 4;
    }

    private class CustomAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        private CustomAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public boolean hasChildren(Object object) {
            if (SearchActorsDialog.this.showOptions == ShowOptions.UNITS && object instanceof Unit) {
                return !((Unit)object).getHasUnits().isEmpty();
            }
            return super.hasChildren(object);
        }
    }

    private class CustomOmItemProviderAdapterFactory
    extends OmItemProviderAdapterFactory {
        private CustomOmItemProviderAdapterFactory() {
        }

        public Adapter createUserAdapter() {
            if (this.userItemProvider == null) {
                this.userItemProvider = new UserItemProvider((AdapterFactory)this){

                    public String getText(Object object) {
                        User user = (User)object;
                        return String.format("%s (%s)", user.getName(), user.getLogin());
                    }
                };
            }
            return this.userItemProvider;
        }
    }

    private class OptionsPatternFilter
    extends PatternFilter {
        private OptionsPatternFilter() {
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            if (element instanceof Unit) {
                return false;
            }
            return super.isParentMatch(viewer, element);
        }
    }

    private class OptionsViewerFilter
    extends ViewerFilter {
        private OptionsViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            switch (SearchActorsDialog.this.showOptions) {
                case USERS: {
                    if (!(element instanceof User)) break;
                    return true;
                }
                case UNITS: {
                    if (!(element instanceof Unit)) break;
                    return true;
                }
                case UNITS_WITH_USERS: {
                    if (element instanceof Unit) {
                        return true;
                    }
                    if ((!(element instanceof User) || !(parentElement instanceof Unit)) && (!(element instanceof User) || !((User)element).getBelongsTo().isEmpty() || !(parentElement instanceof Organization))) break;
                    return true;
                }
            }
            return false;
        }
    }

    private static enum ShowOptions {
        USERS,
        UNITS,
        UNITS_WITH_USERS;

    }
}

