package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;

public class SetLocationWizardPage extends WizardPage {

	private RegisterNewManagerWizardValues values;
	private Text locationText;

	public SetLocationWizardPage(RegisterNewManagerWizardValues values) {
        super("SetLocationWizardPage");
        setTitle("Set Location");
        setDescription("Set the location of the Credentials Manager");
        setPageComplete(false);

        this.values = values;
	}

	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		setControl(composite);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText("Location:");
		
		locationText = new Text(composite, SWT.BORDER);
		IPath location = CredentialsManagerPlugin.getDefault().getStateLocation().append("organization.om");
		GridData layoutData = new GridData(SWT.FILL, SWT.NONE, true, false);
		layoutData.widthHint = 400;
		locationText.setLayoutData(layoutData);

		addListeners();

		locationText.setText(location.toFile().toURI().toString());
	}

	private void addListeners() {
		locationText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				try {
					URI uri = new URI(locationText.getText());
					values.setLocation(uri);
					setErrorMessage(null);
					setPageComplete(true);
				} catch (URISyntaxException e1) {
					setErrorMessage("Invalid location");
				}
			}
		});
	}
}
