package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.wizards;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerType;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;

public class SelectTypeWizardPage extends WizardPage {

	private TableViewer viewer;
	private RegisterNewManagerWizardValues values;

	public SelectTypeWizardPage(RegisterNewManagerWizardValues values) {
        super("SelectRepositoryWizardPage");
        setTitle("Select Credentials Manager Type");
        setDescription("Select a Credentials Manager Type");
        setPageComplete(false);

        this.values = values;
	}

	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		setControl(composite);
		
		viewer = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setInput(CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypes());
		viewer.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof CredentialsManagerType) {
					CredentialsManagerType cm = (CredentialsManagerType) element;
					return String.format("%s (%s)", cm.getName(), cm.getId()); 
				} else {
					return super.getText(element);
				}
			}
			@Override
			public Image getImage(Object element) {
				return CredentialsManagerUIPlugin.getDefault().getImageRegistry().get(
						CredentialsManagerUIPlugin.IMG_OBJ16_UNKNOWN_CM);
			}
		});
		viewer.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		addListeners();
	}

	private void addListeners() {
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if (getSelectedType() != null) {
					values.setType(getSelectedType());
					setPageComplete(true);
				}
			}
		});
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			@Override
			public void doubleClick(DoubleClickEvent event) {
				getContainer().showPage(getNextPage());
			}
		});
	}
	
	public CredentialsManagerType getSelectedType() {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		return (CredentialsManagerType) selection.getFirstElement();
	}
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			viewer.setInput(CredentialsManagerPlugin.getDefault().getManagersRegistry().getManagerTypes());
			viewer.refresh();
		}
	}
		
}
