package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.Organization;
import es.upv.dsic.issi.dplfw.om.Unit;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;
import es.upv.dsic.issi.dplfw.om.provider.OmItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.provider.UserItemProvider;

public class SearchActorsDialog extends Dialog {

	private enum ShowOptions {
		USERS,
		UNITS,
		UNITS_WITH_USERS
	}
	
	private int style;
	private TreeViewer availableViewer;
	private TableViewer selectedViewer;

	private Organization organization;
	
	private ShowOptions showOptions = ShowOptions.UNITS_WITH_USERS;
	private Set<Actor> selectedActors = new LinkedHashSet<Actor>();
		
	private ICredentialsManager credentialsManager;

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * @param style the style of widget to construct
	 *
	 * @see SWT#SINGLE
	 * @see SWT#MULTI
	 * @wbp.parser.constructor
	 */
	public SearchActorsDialog(Shell parentShell, int style) {
		super(parentShell);
		setShellStyle(SWT.MAX | SWT.RESIZE | SWT.TITLE | SWT.APPLICATION_MODAL);
		this.credentialsManager = CredentialsManagerPlugin.getDefault().
				getManagersRegistry().getActiveManager();
		this.organization = credentialsManager.getOrganization();
		this.style = style;
	}

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * @param initialUuids of the pre-selected Actors
	 * @param style the style of widget to construct
	 *
	 * @see SWT#SINGLE
	 * @see SWT#MULTI
	 */
	public SearchActorsDialog(Shell parentShell, List<UUID> initialUuids, int style) {
		this(parentShell, style);
		for (UUID uuid : initialUuids) {
			if (uuid != null) {
				Actor resolveActor = credentialsManager.resolveActor(uuid);
				if (resolveActor != null) {
					selectedActors.add(resolveActor);
				}
			}
		}
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		if (allowSelectMultipleActors()) {
			newShell.setText("Select Actors");
		} else {
			newShell.setText("Select Actor");
		}
	}
	
	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {

		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gl_container = (GridLayout) container.getLayout();
		gl_container.marginWidth = 0;
		gl_container.marginHeight = 0;
		gl_container.horizontalSpacing = 0;
		gl_container.verticalSpacing = 5;
		
		Composite contentComposite = null;
		
		if (allowSelectMultipleActors()) {
			contentComposite = new SashForm(container, SWT.VERTICAL);
			contentComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		} else {
			contentComposite = new Composite(container, SWT.NONE);
			contentComposite.setLayout(new GridLayout(1, false));
			contentComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		}
		
		Composite topComposite = new Composite(contentComposite, SWT.NONE);
		topComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		GridLayout gl_topComposite = new GridLayout(1, false);
		gl_topComposite.marginBottom = 5;
		gl_topComposite.marginTop = 13;
		gl_topComposite.marginWidth = 11;
		gl_topComposite.marginHeight = 0;
		topComposite.setLayout(gl_topComposite);

		Group selectorGroup = new Group(topComposite, SWT.NONE);
		selectorGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		selectorGroup.setText("Options");
		GridLayout gl_selectorGroup = new GridLayout(3, false);
		selectorGroup.setLayout(gl_selectorGroup);
		
		Button usersButton = new Button(selectorGroup, SWT.RADIO);
		usersButton.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		usersButton.setText("Show Use&rs");
		usersButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				showOptions = ShowOptions.USERS;
				availableViewer.refresh();
			}
		});
		
		Button unitsButton = new Button(selectorGroup, SWT.RADIO);
		unitsButton.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		unitsButton.setText("Show Uni&ts");
		unitsButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				showOptions = ShowOptions.UNITS;
				availableViewer.refresh();
			}
		});
		
		Button unitsWithUsersButton = new Button(selectorGroup, SWT.RADIO);
		unitsWithUsersButton.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		unitsWithUsersButton.setText("Show Units &with Users");
		unitsWithUsersButton.setSelection(true);
		unitsWithUsersButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				showOptions = ShowOptions.UNITS_WITH_USERS;
				availableViewer.refresh();
			}
		});
		
		Group resultsGroup = new Group(topComposite, SWT.NONE);
		resultsGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		resultsGroup.setText("Available actors");
		GridLayout gl_resultsGroup = new GridLayout(2, false);
		resultsGroup.setLayout(gl_resultsGroup);
		
		
		PatternFilter patternFilter = new OptionsPatternFilter();
		ViewerFilter optionsFilter = new OptionsViewerFilter();
		
		
		FilteredTree resultsTree= new FilteredTree(resultsGroup, 
				style | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER, patternFilter, true);
		
		availableViewer = resultsTree.getViewer();
		
		availableViewer.getTree().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		availableViewer.setContentProvider(new CustomAdapterFactoryContentProvider(new CustomOmItemProviderAdapterFactory()));
		availableViewer.setLabelProvider(new AdapterFactoryLabelProvider(new CustomOmItemProviderAdapterFactory()));
		availableViewer.setInput(organization);
		availableViewer.setFilters(new ViewerFilter[] { optionsFilter, patternFilter });
		availableViewer.expandToLevel(AbstractTreeViewer.ALL_LEVELS);
		availableViewer.getTree().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				addActorsToSelection();
			}
		});
		
		Button addButton = new Button(resultsGroup, SWT.NONE);
		GridData gd_addButton = new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1);
		gd_addButton.widthHint = 120;
		addButton.setLayoutData(gd_addButton);
		addButton.setText("Select");
		addButton.setImage(CredentialsManagerUIPlugin.getDefault().getImageRegistry().get(
				CredentialsManagerUIPlugin.IMG_TOOL16_DOWN_ARROW));
		addButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				addActorsToSelection();
			}
		});
		
		Composite bottomComposite = new Composite(contentComposite, SWT.NONE);
		bottomComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		GridLayout gl_bottomComposite = new GridLayout(1, false);
		gl_bottomComposite.marginHeight = 0;
		gl_bottomComposite.marginBottom = 13;
		gl_bottomComposite.marginWidth = 11;
		bottomComposite.setLayout(gl_bottomComposite);
		
		Group selectedActorsGroup = new Group(bottomComposite, SWT.NONE);
		selectedActorsGroup.setLayout(new GridLayout(2, false));
		selectedActorsGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		if (allowSelectMultipleActors()) {
			selectedActorsGroup.setText("Selected actors");
		} else {
			selectedActorsGroup.setText("Selected actor");
			
		}
		
		Composite dummyComposite = new Composite(selectedActorsGroup, SWT.NONE);
		dummyComposite.setLayout(new FillLayout(SWT.HORIZONTAL | SWT.VERTICAL));
		
		
		selectedViewer = new TableViewer(dummyComposite, SWT.BORDER | SWT.FULL_SELECTION | style);
		
		if (allowSelectMultipleActors()) {
			GridData dummyLayoutData = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
			dummyComposite.setLayoutData(dummyLayoutData);
		} else {
			GridData dummyLayoutData = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
			dummyComposite.setLayoutData(dummyLayoutData);
			dummyLayoutData.heightHint = selectedViewer.getTable().getItemHeight() + 
					2 * selectedViewer.getTable().getBorderWidth();
		}
		
		selectedViewer.setContentProvider(new ArrayContentProvider());
		selectedViewer.setLabelProvider(new AdapterFactoryLabelProvider(new CustomOmItemProviderAdapterFactory()));
		selectedViewer.setInput(selectedActors);
		
		Button removeButton = new Button(selectedActorsGroup, SWT.NONE);
		removeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_ETOOL_DELETE));
		GridData gd_removeButton = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_removeButton.widthHint = 120;
		removeButton.setLayoutData(gd_removeButton);
		removeButton.setText("Unselect");
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				removeActorsFromSelection();
			}
		});
		
		if (allowSelectMultipleActors()) {
			((SashForm)contentComposite).setWeights(new int[] {3, 2});
		}
		
		return container;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(600, 700);
	}

	public Collection<Actor> getActors() {
		return selectedActors;
	}
	
	@SuppressWarnings("unchecked")
	private void addActorsToSelection() {
		if (!allowSelectMultipleActors()) {
			selectedActors.clear();
		}
		IStructuredSelection selection = (IStructuredSelection) availableViewer.getSelection();
		selectedActors.addAll(selection.toList());
		selectedViewer.refresh();
		selectedViewer.setSelection(selection);
	}
	
	private void removeActorsFromSelection() {
		IStructuredSelection selection = (IStructuredSelection)selectedViewer.getSelection();
		selectedActors.removeAll(selection.toList());
		selectedViewer.refresh();
		availableViewer.setSelection(selection);
	}
	
	private class OptionsViewerFilter extends ViewerFilter {
		@Override
		public boolean select(Viewer viewer, Object parentElement, Object element) {
			switch (showOptions) {
				case USERS:
					if (element instanceof User) 
						return true;
					break;
				case UNITS:
					if (element instanceof Unit)
						return true;
					break;
				case UNITS_WITH_USERS:
					if (element instanceof Unit)
						return true;
					else if ((element instanceof User && parentElement instanceof Unit) ||
							(element instanceof User && ((User) element).getBelongsTo().isEmpty() && parentElement instanceof Organization)) 
						return true;
					break;
			}
			return false;
		}
	}

	private class OptionsPatternFilter extends PatternFilter {
		@Override
		protected boolean isParentMatch(Viewer viewer, Object element) {
			if (element instanceof Unit) {
				return false;
			} else {
				return super.isParentMatch(viewer, element);
			}
		}
	}

	private class CustomAdapterFactoryContentProvider extends
			AdapterFactoryContentProvider {
		private CustomAdapterFactoryContentProvider(
				AdapterFactory adapterFactory) {
			super(adapterFactory);
		}

		@Override
		public boolean hasChildren(Object object) {
			if (showOptions == ShowOptions.UNITS && object instanceof Unit) {
				return !((Unit) object).getHasUnits().isEmpty();
			} else {
				return super.hasChildren(object);
			}
		}
	}

	
	private class CustomOmItemProviderAdapterFactory extends OmItemProviderAdapterFactory {
		@Override
		public Adapter createUserAdapter() {
			if (userItemProvider == null) {
				userItemProvider = new UserItemProvider(this) {
					@Override
					public String getText(Object object) {
						User user = (User) object;
						return String.format("%s (%s)", user.getName(), user.getLogin());
					}
				};
			}
			
			return userItemProvider;
		}
	}
	
	private boolean allowSelectMultipleActors() {
		return ((style & SWT.MULTI) == SWT.MULTI) &&
				!((style & SWT.SINGLE) == SWT.SINGLE);
	}
}
