package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.om.credentialsmanager.ILoginProvider;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.CancelledLoginException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.CredentialsManagerUIPlugin;

public class LoginDialog extends Dialog implements ILoginProvider {

	private Text loginField;
	private Text passwordField;

	private String login;
	private String password;

	public LoginDialog(Shell parentShell) {
		super(parentShell);
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Login");
		newShell.setImage(CredentialsManagerUIPlugin.getDefault().getImageRegistry().get(
				CredentialsManagerUIPlugin.IMG_OTHER64_LOGIN));
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);

	    composite.setLayout(new GridLayout(2, false));

	    Label usernameLabel = new Label(composite, SWT.RIGHT);
	    usernameLabel.setText("Username:");

	    loginField = new Text(composite, SWT.SINGLE | SWT.BORDER);
	    loginField.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

	    Label passwordLabel = new Label(composite, SWT.RIGHT);
	    passwordLabel.setText("Password: ");

	    passwordField = new Text(composite, SWT.SINGLE | SWT.PASSWORD | SWT.BORDER);
	    passwordField.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

	    return composite;
	}
	
	@Override
	protected void okPressed() {
		login = StringUtils.defaultIfEmpty(loginField.getText(), "");
		password = StringUtils.defaultIfEmpty(passwordField.getText(), "");
		super.okPressed();
	}
	
	@Override
	public String getLogin() {
		return login;
	}
	
	@Override
	public String getPassword() {
		return password;
	}

	@Override
	public void requestCredentials() throws CancelledLoginException {
		if(open() == Dialog.CANCEL) {
			throw new CancelledLoginException();
		}
	}

}
