package es.upv.dsic.issi.dplfw.om.credentialsmanager.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The activator class controls the plug-in life cycle
 */
public class CredentialsManagerUIPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "es.upv.dsic.issi.dplfw.om.credentialsmanager.ui"; //$NON-NLS-1$

	public static final String IMG_OBJ16_UNKNOWN_CM = "IMG_OBJ16_UNKNOWN_CM";
	public static final String IMG_TOOL16_DOWN_ARROW = "IMG_TOOL16_DOWN_ARROW ";
	public static final String IMG_OTHER64_LOGIN = "IMG_OTHER64_LOGIN ";

	// The shared instance
	private static CredentialsManagerUIPlugin plugin;
	
	/**
	 * The constructor
	 */
	public CredentialsManagerUIPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static CredentialsManagerUIPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);
		reg.put(IMG_OBJ16_UNKNOWN_CM, CredentialsManagerUIPlugin
				.getImageDescriptor("icons/full/obj16/centralised_cm.png").createImage());
		reg.put(IMG_TOOL16_DOWN_ARROW, CredentialsManagerUIPlugin
				.getImageDescriptor("icons/full/tool16/down_arrow.png").createImage());
		reg.put(IMG_OTHER64_LOGIN, CredentialsManagerUIPlugin
				.getImageDescriptor("icons/full/other64/login.png").createImage());
	}
}
