/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelements.impl;

import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;
import es.upv.dsic.issi.dplfw.infoelements.impl.InfoElementImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class TextIEImpl
extends InfoElementImpl
implements TextIE {
    @Override
    protected EClass eStaticClass() {
        return InfoelementsPackage.Literals.TEXT_IE;
    }

    @Override
    public String getContents() {
        return (String)this.eGet((EStructuralFeature)InfoelementsPackage.Literals.TEXT_IE__CONTENTS, true);
    }

    @Override
    public void setContents(String newContents) {
        this.eSet((EStructuralFeature)InfoelementsPackage.Literals.TEXT_IE__CONTENTS, newContents);
    }

    @Override
    public Document asDita(String workingDir) throws ParserConfigurationException {
        Node conbodyNode;
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        DocumentType documentType = doc.getImplementation().createDocumentType("concept", "-//OASIS//DTD DITA Concept//EN", "concept.dtd");
        doc.appendChild(documentType);
        Element concept = doc.createElement("concept");
        doc.appendChild(concept);
        concept.setAttribute("id", "_" + this.getUuid().toString());
        Element title = doc.createElement("title");
        concept.appendChild(title);
        title.setTextContent(this.getTitle());
        Element prolog = doc.createElement("prolog");
        concept.appendChild(prolog);
        for (String authorName : this.getAuthor()) {
            Element author = doc.createElement("author");
            prolog.appendChild(author);
            author.setAttribute("type", "creator");
            author.setTextContent(authorName);
        }
        Element publisher = doc.createElement("publisher");
        prolog.appendChild(publisher);
        publisher.setTextContent(this.getPublisher());
        Element critdates = doc.createElement("critdates");
        prolog.appendChild(critdates);
        Element created = doc.createElement("created");
        critdates.appendChild(created);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        created.setAttribute("date", dateFormat.format(this.getDateCreation()));
        Element metadata = doc.createElement("metadata");
        prolog.appendChild(metadata);
        Element keywords = doc.createElement("keywords");
        metadata.appendChild(keywords);
        for (String keywordName : this.getKeywords()) {
            Element keyword = doc.createElement("keyword");
            keywords.appendChild(keyword);
            keyword.setTextContent(keywordName);
        }
        Element language = doc.createElement("othermeta");
        metadata.appendChild(language);
        language.setAttribute("name", "language");
        language.setAttribute("content", this.getLanguage().getLiteral());
        if (this.getContents() != null && (conbodyNode = this.getContentsAsNode(doc)) != null) {
            concept.appendChild(conbodyNode);
        }
        return doc;
    }

    private Node getContentsAsNode(Document document) {
        Node conbodyNode = null;
        if (this.getContents() != null) {
            ByteArrayInputStream inStream;
            String html = StringEscapeUtils.unescapeHtml4((String)this.getContents());
            html = "<html><head><title>" + this.getTitle() + "</title></head><body>" + html + "</body></html>";
            Tidy tidy = new Tidy();
            tidy.setHideEndTags(false);
            tidy.setDocType("omit");
            tidy.setDropProprietaryAttributes(true);
            tidy.setMakeBare(true);
            tidy.setMakeClean(true);
            tidy.setXHTML(true);
            tidy.setDropFontTags(true);
            tidy.setInputEncoding("utf-8");
            tidy.setTidyMark(false);
            tidy.setWord2000(true);
            tidy.setShowErrors(0);
            tidy.setShowWarnings(true);
            try {
                inStream = new ByteArrayInputStream(html.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                inStream = new ByteArrayInputStream(html.getBytes());
            }
            Properties oProps = new Properties();
            oProps.setProperty("new-inline-tags", "keyword");
            oProps.setProperty("new-empty-tags", "keyword");
            tidy.setConfigurationFromProps(oProps);
            Document doc = tidy.parseDOM((InputStream)inStream, null);
            int i2 = 0;
            while (i2 < doc.getElementsByTagName("table").getLength()) {
                Node node = doc.getElementsByTagName("table").item(i2);
                if (node.getAttributes().getNamedItem("align") != null) {
                    node.getAttributes().removeNamedItem("align");
                }
                ++i2;
            }
            try {
                Throwable i2 = null;
                Object var9_13 = null;
                try (InputStream inputStream = TextIEImpl.class.getResourceAsStream("/xsl/h2d.xsl");){
                    Transformer transformer = new TransformerFactoryImpl().newTransformer((Source)new StreamSource(inputStream));
                    transformer.setParameter("infotype", "concept");
                    DOMResult result = new DOMResult();
                    transformer.transform(new DOMSource(doc), result);
                    Document resultDoc = (Document)result.getNode();
                    NodeList list = resultDoc.getElementsByTagName("conbody");
                    if (list != null && list.getLength() > 0 && list.item(0) instanceof Node) {
                        Node node = list.item(0);
                        conbodyNode = document.importNode(node, true);
                    }
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    throw i2;
                }
            }
            catch (IOException | TransformerException e) {
                e.printStackTrace();
            }
        }
        return conbodyNode;
    }
}

