/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MapType implements Enumerator
{
    MAP(0, "Map", "Map"),
    SATELLITE(1, "Satellite", "Satellite"),
    HYBRID(2, "Hybrid", "Hybrid"),
    TERRAIN(3, "Terrain", "Terrain");

    public static final int MAP_VALUE = 0;
    public static final int SATELLITE_VALUE = 1;
    public static final int HYBRID_VALUE = 2;
    public static final int TERRAIN_VALUE = 3;
    private static final MapType[] VALUES_ARRAY;
    public static final List<MapType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MapType[]{MAP, SATELLITE, HYBRID, TERRAIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MapType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapType get(int value) {
        switch (value) {
            case 0: {
                return MAP;
            }
            case 1: {
                return SATELLITE;
            }
            case 2: {
                return HYBRID;
            }
            case 3: {
                return TERRAIN;
            }
        }
        return null;
    }

    private MapType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

