package es.upv.dsic.issi.dplfw.infoelements.util;

import java.util.Collection;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;

public class InfoelementsEcoreUtil {

	/**
	 * Returns a collection of the self-contained copies of each {@link EObject}
	 * in eObjects.
	 * Changeable EAttributes are also copied 
	 * @param eObjects the collection of objects to copy.
	 * @return the collection of copies.
	 * @see Copier
	 */
	public static <T> Collection<T> fullCopyAll(Collection<? extends T> eObjects) {
		Copier copier = new FullCopier();
	    Collection<T> result = copier.copyAll(eObjects);
	    copier.copyReferences();
	    return result;
	}
	
	  /**
	   * Returns a self-contained copy of the eObject.
	   * Changeable EAttributes are also copied
	   * @param eObject the object to copy.
	   * @return the copy.
	   * @see Copier
	   */
	  public static <T extends EObject> T fullCopy(T eObject)
	  {
	    Copier copier = new FullCopier();
	    EObject result = copier.copy(eObject);
	    copier.copyReferences();
	    
	    @SuppressWarnings("unchecked")T t = (T)result;
	    return t;
	  }
	
	
	protected static class FullCopier extends Copier {

		private static final long serialVersionUID = 1L;
		
		@Override
		public EObject copy(EObject eObject) {
			if (eObject == null) {
				return null;
			} else {
				EObject copyEObject = createCopy(eObject);
				put(eObject, copyEObject);
				EClass eClass = eObject.eClass();
				for (int i = 0, size = eClass.getFeatureCount(); i < size; ++i) {
					EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
					if (!eStructuralFeature.isDerived()) {
						if (eStructuralFeature instanceof EAttribute) {
							copyAttribute((EAttribute) eStructuralFeature, eObject, copyEObject);
						} else {
							EReference eReference = (EReference) eStructuralFeature;
							if (eReference.isContainment()) {
								copyContainment(eReference, eObject, copyEObject);
							}
						}
					}
				}

				copyProxyURI(eObject, copyEObject);

				return copyEObject;
			}
		}
		
		@Override
		protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
			if (!eAttribute.isChangeable()) {
				synchronized (eAttribute) {
					eAttribute.setChangeable(true);
					super.copyAttribute(eAttribute, eObject, copyEObject);
					eAttribute.setChangeable(false);
				}
			} else {
				super.copyAttribute(eAttribute, eObject, copyEObject);
			}
		}
	}
}
