/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.infoelements.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.eclipse.emf.ecore.EClass;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Text IE</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.infoelements.impl.TextIEImpl#getContents <em>Contents</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TextIEImpl extends InfoElementImpl implements TextIE {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TextIEImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return InfoelementsPackage.Literals.TEXT_IE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getContents() {
		return (String)eGet(InfoelementsPackage.Literals.TEXT_IE__CONTENTS, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContents(String newContents) {
		eSet(InfoelementsPackage.Literals.TEXT_IE__CONTENTS, newContents);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public Document asDita(String workingDir) throws ParserConfigurationException {
		DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();

        DocumentType documentType = doc.getImplementation().createDocumentType(
        		"concept", "-//OASIS//DTD DITA Concept//EN", "concept.dtd");
        doc.appendChild(documentType);
        
        Element concept = doc.createElement("concept");
        doc.appendChild(concept);
        concept.setAttribute("id", "_" + getUuid().toString());

        Element title = doc.createElement("title");
        concept.appendChild(title);
        title.setTextContent(getTitle());

//        Element shortdesc = doc.createElement("shortdesc");
//        concept.appendChild(shortdesc);
//        shortdesc.setTextContent(getDescription());
        
        Element prolog = doc.createElement("prolog");
        concept.appendChild(prolog);
        
        for (String authorName : getAuthor()) {
            Element author = doc.createElement("author");
            prolog.appendChild(author);
            author.setAttribute("type", "creator");
            author.setTextContent(authorName);
        }

        
        Element publisher = doc.createElement("publisher");
        prolog.appendChild(publisher);
        publisher.setTextContent(getPublisher());

        
        Element critdates = doc.createElement("critdates");
        prolog.appendChild(critdates);
        Element created = doc.createElement("created");
        critdates.appendChild(created);
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        created.setAttribute("date", dateFormat.format(getDateCreation()));

        Element metadata = doc.createElement("metadata");
        prolog.appendChild(metadata);
        
        Element keywords = doc.createElement("keywords");
        metadata.appendChild(keywords);

        for (String keywordName : getKeywords()) {
            Element keyword = doc.createElement("keyword");
            keywords.appendChild(keyword);
            keyword.setTextContent(keywordName);
        }
        
        Element language = doc.createElement("othermeta");
        metadata.appendChild(language);
        language.setAttribute("name", "language");
        language.setAttribute("content", getLanguage().getLiteral());

//        Element conbody = doc.createElement("conbody");
//        concept.appendChild(conbody);
        
        if (getContents() != null) {
//	        String[] paragraphs = getContents().split(System.getProperty("line.separator"));
//	        for (String paragraph : paragraphs) {
//	        	if (!paragraph.isEmpty()) {
//			        Element p = doc.createElement("p");
//			        conbody.appendChild(p);
//			        p.setTextContent(paragraph);
//	        	}
//	        }
        	
        	Node conbodyNode = getContentsAsNode(doc);
        	if (conbodyNode != null) {
        		concept.appendChild(conbodyNode);
        	}
        }
        
        return doc;
	}

	
	private Node getContentsAsNode(Document document){
		
		Node conbodyNode = null;
		if (getContents() != null) {
			String html = StringEscapeUtils.unescapeHtml4(getContents());
			html = "<html><head><title>" + getTitle() + "</title></head><body>" + html + "</body></html>";
			
			Tidy tidy = new Tidy();
			tidy.setHideEndTags(false);
			tidy.setDocType("omit");
			tidy.setDropProprietaryAttributes(true); 
			tidy.setMakeBare(true);
			tidy.setMakeClean(true);
			tidy.setXHTML(true);
			tidy.setDropFontTags(true);
			tidy.setInputEncoding("utf-8");
			tidy.setTidyMark(false);
			tidy.setWord2000(true);
			tidy.setShowErrors(0);
			tidy.setShowWarnings(true);
			ByteArrayInputStream inStream;
			try {
				inStream = new ByteArrayInputStream(html.getBytes("UTF-8"));
			} catch (UnsupportedEncodingException e1) {
				inStream = new ByteArrayInputStream(html.getBytes());
			}
			
			Properties oProps = new Properties();
			oProps.setProperty("new-inline-tags", "keyword");
			oProps.setProperty("new-empty-tags", "keyword");
			tidy.setConfigurationFromProps(oProps);
			
			Document doc = tidy.parseDOM(inStream, null);
			
			for (int i = 0; i < doc.getElementsByTagName("table").getLength(); i++) {
				Node node = doc.getElementsByTagName("table").item(i);
				if (node.getAttributes().getNamedItem("align") != null) {
					node.getAttributes().removeNamedItem("align");
				}
			}
			
			try (InputStream inputStream = TextIEImpl.class.getResourceAsStream("/xsl/h2d.xsl");){
				// We directly use the Xalan TransformerFactory to avoid collisions with Saxon9
				// in which the h2d.xsl XSLT transformation no longer works
				Transformer transformer = new TransformerFactoryImpl().newTransformer(new StreamSource(inputStream));
				transformer.setParameter("infotype", "concept");
				DOMResult result = new DOMResult();
				transformer.transform(new DOMSource(doc), result);
				Document resultDoc = (Document) result.getNode();
				NodeList list = resultDoc.getElementsByTagName("conbody");
				if (list != null && list.getLength() > 0 && list.item(0) instanceof Node) {
					Node node = (Node) list.item(0);
					conbodyNode = document.importNode(node, true);
				}				
			} catch (TransformerException | IOException e) {
				e.printStackTrace();
			}
		}
		return conbodyNode; 
	}
	
} //TextIEImpl
