/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.infoelements.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.ImageIEContents;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Image IE</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.infoelements.impl.ImageIEImpl#getDisplayWidth <em>Display Width</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.infoelements.impl.ImageIEImpl#getDisplayHeight <em>Display Height</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.infoelements.impl.ImageIEImpl#getImageContents <em>Image Contents</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ImageIEImpl extends InfoElementImpl implements ImageIE {
	
//	private final class ByteArrayImageInputStream extends ImageInputStreamImpl {
//		
//		private ByteArrayInputStream byteArrayInputStream;
//		
//		public ByteArrayImageInputStream(ByteArrayInputStream byteArrayInputStream) {
//			this.byteArrayInputStream = byteArrayInputStream;
//		}
//
//		@Override
//		public int read(byte[] arg0, int arg1, int arg2) throws IOException {
//			return byteArrayInputStream.read(arg0, arg1, arg2);
//		}
//
//		@Override
//		public int read() throws IOException {
//			return byteArrayInputStream.read();
//		}
//	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImageIEImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return InfoelementsPackage.Literals.IMAGE_IE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDisplayWidth() {
		return (Integer)eGet(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDisplayWidth(int newDisplayWidth) {
		eSet(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, newDisplayWidth);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDisplayHeight() {
		return (Integer)eGet(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDisplayHeight(int newDisplayHeight) {
		eSet(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, newDisplayHeight);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ImageIEContents getImageContents() {
		return (ImageIEContents)eGet(InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImageContents(ImageIEContents newImageContents) {
		eSet(InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, newImageContents);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public byte[] getContents() {
		return getImageContents() != null ? getImageContents().getContents() : null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void setContents(byte[] newContents) {
		ImageIEContents imageContents = InfoelementsFactory.eINSTANCE.createImageIEContents();
		imageContents.setContents(newContents);
		eSet((EStructuralFeature) InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, imageContents);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public Document asDita(String workingDir) throws ParserConfigurationException {
		DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();

        DocumentType documentType = doc.getImplementation().createDocumentType(
        		"concept", "-//OASIS//DTD DITA Concept//EN", "concept.dtd");
        doc.appendChild(documentType);
        
        Element concept = doc.createElement("concept");
        doc.appendChild(concept);
        concept.setAttribute("id", "_" + getUuid().toString());

        Element title = doc.createElement("title");
        concept.appendChild(title);
        title.setTextContent(getTitle());

        Element shortdesc = doc.createElement("shortdesc");
        concept.appendChild(shortdesc);
        shortdesc.setTextContent(getDescription());
        
        Element prolog = doc.createElement("prolog");
        concept.appendChild(prolog);
        
        for (String authorName : getAuthor()) {
            Element author = doc.createElement("author");
            prolog.appendChild(author);
            author.setAttribute("type", "creator");
            author.setTextContent(authorName);
        }

        
        Element publisher = doc.createElement("publisher");
        prolog.appendChild(publisher);
        publisher.setTextContent(getPublisher());

        
        Element critdates = doc.createElement("critdates");
        prolog.appendChild(critdates);
        Element created = doc.createElement("created");
        critdates.appendChild(created);
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        created.setAttribute("date", dateFormat.format(getDateCreation()));

        Element metadata = doc.createElement("metadata");
        prolog.appendChild(metadata);
        
        Element keywords = doc.createElement("keywords");
        metadata.appendChild(keywords);

        for (String keywordName : getKeywords()) {
            Element keyword = doc.createElement("keyword");
            keywords.appendChild(keyword);
            keyword.setTextContent(keywordName);
        }
        
        Element language = doc.createElement("othermeta");
        metadata.appendChild(language);
        language.setAttribute("name", "language");
        language.setAttribute("content", getLanguage().getLiteral());

        Element conbody = doc.createElement("conbody");
        concept.appendChild(conbody);
        
        Element image = doc.createElement("image");
        conbody.appendChild(image);
        
        if (getImageContents() != null) {
        	image.setAttribute("align", "center");
        	image.setAttribute("placement", "break");
        	image.setAttribute("width", String.valueOf(getDisplayWidth()));
        	image.setAttribute("height", String.valueOf(getDisplayHeight()));
        	if (workingDir != null) {
    		
    			String fileName = workingDir + File.separator + getUuid();
        		File file = new File(fileName);
        		FileOutputStream outputStream = null;
        		try {
        			if (!file.exists()) {
        				file.getParentFile().mkdirs();
        			}
					outputStream = new FileOutputStream(file);
					outputStream.write(getImageContents().getContents());
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					if (outputStream != null) {
						try {
							outputStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}

        		String formatName = "";
        		ImageInputStream fileImageInputStream = null;
				try {
					fileImageInputStream = ImageIO.createImageInputStream(file);
					Iterator<ImageReader> it = ImageIO.getImageReaders(fileImageInputStream);
					if (it.hasNext()) {
						ImageReader reader = it.next();
						formatName = reader.getFormatName().toLowerCase();
					}
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					if (fileImageInputStream != null) {
						try {
							fileImageInputStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}
				if (formatName != null && !formatName.equals("")) {
					fileName = fileName + "." + formatName;
	        		File newFile = new File (fileName);
	        		if (newFile.exists()) {
	        			newFile.delete();
	        		}
					file.renameTo(newFile);
				}
				image.setAttribute("href", fileName.replace(workingDir + File.separator, ""));
        	}
        }
        
        return doc;
	}

} //ImageIEImpl
