/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.infoelements.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import es.upv.dsic.issi.dplfw.infoelements.util.InfoelementsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class InfoelementsItemProviderAdapterFactory extends InfoelementsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InfoelementsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.TextIE} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextIEItemProvider textIEItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.TextIE}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextIEAdapter() {
		if (textIEItemProvider == null) {
			textIEItemProvider = new TextIEItemProvider(this);
		}

		return textIEItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.ImageIE} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageIEItemProvider imageIEItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.ImageIE}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImageIEAdapter() {
		if (imageIEItemProvider == null) {
			imageIEItemProvider = new ImageIEItemProvider(this);
		}

		return imageIEItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.LinkIE} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkIEItemProvider linkIEItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.LinkIE}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkIEAdapter() {
		if (linkIEItemProvider == null) {
			linkIEItemProvider = new LinkIEItemProvider(this);
		}

		return linkIEItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.ImageIEContents} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageIEContentsItemProvider imageIEContentsItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.ImageIEContents}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImageIEContentsAdapter() {
		if (imageIEContentsItemProvider == null) {
			imageIEContentsItemProvider = new ImageIEContentsItemProvider(this);
		}

		return imageIEContentsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.LocationIE} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocationIEItemProvider locationIEItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.LocationIE}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocationIEAdapter() {
		if (locationIEItemProvider == null) {
			locationIEItemProvider = new LocationIEItemProvider(this);
		}

		return locationIEItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.LocationMapPreviewIE} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocationMapPreviewIEItemProvider locationMapPreviewIEItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.LocationMapPreviewIE}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocationMapPreviewIEAdapter() {
		if (locationMapPreviewIEItemProvider == null) {
			locationMapPreviewIEItemProvider = new LocationMapPreviewIEItemProvider(this);
		}

		return locationMapPreviewIEItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.infoelements.VariableIEContents} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableIEContentsItemProvider variableIEContentsItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.infoelements.VariableIEContents}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableIEContentsAdapter() {
		if (variableIEContentsItemProvider == null) {
			variableIEContentsItemProvider = new VariableIEContentsItemProvider(this);
		}

		return variableIEContentsItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (textIEItemProvider != null) textIEItemProvider.dispose();
		if (imageIEItemProvider != null) imageIEItemProvider.dispose();
		if (linkIEItemProvider != null) linkIEItemProvider.dispose();
		if (imageIEContentsItemProvider != null) imageIEContentsItemProvider.dispose();
		if (locationIEItemProvider != null) locationIEItemProvider.dispose();
		if (locationMapPreviewIEItemProvider != null) locationMapPreviewIEItemProvider.dispose();
		if (variableIEContentsItemProvider != null) variableIEContentsItemProvider.dispose();
	}

}
