/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.preferences;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SubjectsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public SubjectsPreferencePage() {
        super(1);
        this.setPreferenceStore(IESingleEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Subjects which can be associated to Info Elements");
    }

    public void createFieldEditors() {
        SubjectsListEditor subjectFieldEditor = new SubjectsListEditor("P_SUBJECTS", "Available &subjects:", this.getFieldEditorParent());
        List list = subjectFieldEditor.getListControl(this.getFieldEditorParent());
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.minimumHeight = 200;
        layoutData.heightHint = 200;
        layoutData.minimumWidth = 400;
        list.setLayoutData((Object)layoutData);
        this.addField((FieldEditor)subjectFieldEditor);
    }

    public void init(IWorkbench workbench) {
    }

    private final class SubjectsListEditor
    extends ListEditor {
        private SubjectsListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected String[] parseString(String stringList) {
            return stringList.trim().split("\t");
        }

        protected String getNewInputObject() {
            InputDialog dialog = new InputDialog(this.getShell(), "New subject", "Enter a new subject:", "", new IInputValidator(){

                public String isValid(String newText) {
                    return StringUtils.isBlank((CharSequence)newText) ? "Subject cannot be empty" : null;
                }
            });
            if (dialog.open() == 0) {
                return dialog.getValue();
            }
            return null;
        }

        public Composite getButtonBoxControl(Composite parent) {
            Composite buttonBoxControl = super.getButtonBoxControl(parent);
            if (buttonBoxControl.getLayout() instanceof GridLayout) {
                GridLayout layout = (GridLayout)buttonBoxControl.getLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
            }
            return buttonBoxControl;
        }

        protected String createList(String[] items) {
            StringBuilder builder = new StringBuilder();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                builder.append(item);
                builder.append("\t");
                ++n2;
            }
            return builder.toString().trim();
        }
    }
}

