/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.html;

import es.upv.dsic.issi.dplfw.core.util.ZIPUtil;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextEditAbstractControl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class TextEditHtmlControl
extends TextEditAbstractControl {
    private static final String EDITOR_FILENAME = "editor.html";
    private static final String CSS_FILENAME = "content.css";
    private static final String WORKING_DIRECTORY = "editor";
    private static final String RESOURCES_DIRECTORY = "resources";
    private static final String PLUGINS_SOURCE_DIRECTORY = "resources" + File.separator + "mce_plugins";
    private static final String PLUGINS_TARGET_DIRECTORY = "tinymce/jscripts/tiny_mce/plugins";
    private static final String TINYMCE_FILENAME = "tinymce_3.5.7.zip";
    private static final String LIPSUM_FILENAME = "loremipsum_0.1.2.zip";
    private static final String VARIABLES_FILENAME = "variables.zip";
    private static final String LIPSUM_ICON_PATH = "loremipsum/img";
    private static final String LIPSUM_ICON_FILENAME = "loremipsum.gif";
    private Browser browser;
    private String text;

    public TextEditHtmlControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new TableWrapLayout());
        this.browser = new Browser((Composite)this, 0);
        new FireModifyEventFunction(this.browser, "fireModifyEvent");
        new InitializeFunction(this.browser, "initializeContents");
        TableWrapData layoutData = new TableWrapData(256, 256);
        layoutData.heightHint = 400;
        this.browser.setLayoutData((Object)layoutData);
        try {
            File directory = IESingleEditorPlugin.getDefault().getBundle().getDataFile(WORKING_DIRECTORY);
            this.prepareOnDir(directory);
            this.browser.setUrl(String.valueOf(directory.getAbsolutePath()) + File.separator + EDITOR_FILENAME);
            this.browser.setJavascriptEnabled(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareOnDir(File directory) throws IOException {
        InputStream tinyMCEStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(RESOURCES_DIRECTORY + File.separator + TINYMCE_FILENAME), (boolean)false);
        ZIPUtil.unzip((InputStream)tinyMCEStream, (File)directory, (boolean)false);
        InputStream lipsumStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(String.valueOf(PLUGINS_SOURCE_DIRECTORY) + File.separator + LIPSUM_FILENAME), (boolean)false);
        ZIPUtil.unzip((InputStream)lipsumStream, (File)new File(String.valueOf(directory.getAbsolutePath()) + File.separator + PLUGINS_TARGET_DIRECTORY), (boolean)false);
        InputStream variablesStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(String.valueOf(PLUGINS_SOURCE_DIRECTORY) + File.separator + VARIABLES_FILENAME), (boolean)false);
        ZIPUtil.unzip((InputStream)variablesStream, (File)new File(String.valueOf(directory.getAbsolutePath()) + File.separator + PLUGINS_TARGET_DIRECTORY), (boolean)false);
        InputStream editorStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(RESOURCES_DIRECTORY + File.separator + EDITOR_FILENAME), (boolean)false);
        FileUtils.copyInputStreamToFile((InputStream)editorStream, (File)new File(directory + File.separator + EDITOR_FILENAME));
        InputStream cssStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(RESOURCES_DIRECTORY + File.separator + CSS_FILENAME), (boolean)false);
        FileUtils.copyInputStreamToFile((InputStream)cssStream, (File)new File(directory + File.separator + CSS_FILENAME));
        InputStream lipsumIconStream = FileLocator.openStream((Bundle)IESingleEditorPlugin.getDefault().getBundle(), (IPath)new Path(RESOURCES_DIRECTORY + File.separator + LIPSUM_ICON_FILENAME), (boolean)false);
        FileUtils.copyInputStreamToFile((InputStream)lipsumIconStream, (File)new File(new File(String.valueOf(directory.getAbsolutePath()) + File.separator + PLUGINS_TARGET_DIRECTORY + File.separator + LIPSUM_ICON_PATH) + File.separator + LIPSUM_ICON_FILENAME));
    }

    protected void fireModifyEvent() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TextEditHtmlControl.this.isDisposed()) {
                    TextEditHtmlControl.this.notifyListeners(24, new Event());
                }
            }
        });
    }

    public Browser getBrowserControl() {
        return this.browser;
    }

    @Override
    public void setText(String textMessage) {
        this.text = textMessage;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getVariablesString() {
        StringBuffer vars = new StringBuffer();
        Iterator iter = this.variables.iterator();
        vars.append('[');
        while (iter.hasNext()) {
            vars.append("'" + iter.next() + "'");
            if (!iter.hasNext()) continue;
            vars.append(',');
        }
        vars.append(']');
        return vars.toString();
    }

    private class FireModifyEventFunction
    extends BrowserFunction {
        public FireModifyEventFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            TextEditHtmlControl.this.browser.execute(String.format("tinyMCE.activeEditor.variables = " + TextEditHtmlControl.this.getVariablesString() + ";", new Object[0]));
            Object contents = TextEditHtmlControl.this.browser.evaluate("return tinyMCE.activeEditor.getContent({format : 'raw'});");
            if (contents instanceof String) {
                TextEditHtmlControl.this.text = (String)contents;
                TextEditHtmlControl.this.fireModifyEvent();
            }
            return null;
        }
    }

    private class InitializeFunction
    extends BrowserFunction {
        public InitializeFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            TextEditHtmlControl.this.browser.execute(String.format("tinyMCE.activeEditor.variables = " + TextEditHtmlControl.this.getVariablesString() + ";", new Object[0]));
            TextEditHtmlControl.this.browser.execute(String.format("tinyMCE.activeEditor.setContent('%s',{format : 'raw'});", TextEditHtmlControl.this.text));
            TextEditHtmlControl.this.browser.execute("resizeEditorToFillSpace();");
            return null;
        }
    }
}

