/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.html;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextDisplayAbstractControl;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TextDisplayHtmlControl
extends TextDisplayAbstractControl {
    private Browser browser;
    private String jsHeight = "var D = document;  return Math.max(      Math.max(D.body.scrollHeight, D.documentElement.scrollHeight),      Math.max(D.body.offsetHeight, D.documentElement.offsetHeight),      Math.max(D.body.clientHeight, D.documentElement.clientHeight)   );";
    private String jsWidth = "var D = document;  return Math.max(      Math.max(D.body.scrollWidth, D.documentElement.scrollWidth),      Math.max(D.body.offsetWidth, D.documentElement.offsetWidth),      Math.max(D.body.clientWidth, D.documentElement.clientWidth)   );";
    private TableWrapData layoutData;

    public TextDisplayHtmlControl(Composite parent, int style) {
        super(parent, style);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 20;
        layout.rightMargin = 20;
        layout.topMargin = 20;
        layout.bottomMargin = 20;
        this.setLayout((Layout)layout);
        this.browser = new Browser((Composite)this, 66);
        this.layoutData = new TableWrapData(256, 256);
        this.browser.setLayoutData((Object)this.layoutData);
        new BrowserFunction(this.browser, "refresh"){

            public Object function(Object[] arguments) {
                TextDisplayHtmlControl.this.updateHeight();
                TextDisplayHtmlControl.this.notifyListeners(11, new Event());
                return null;
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TextDisplayHtmlControl.this.updateHeight();
            }
        });
    }

    @Override
    public void refresh() {
        this.browser.setText(this.buildFormContent(), true);
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                TextDisplayHtmlControl.this.updateHeight();
                TextDisplayHtmlControl.this.notifyListeners(11, new Event());
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private void updateHeight() {
        try {
            int height = 300;
            Object objHeight = this.browser.evaluate(this.jsHeight);
            if (objHeight != null && objHeight instanceof Double) {
                height = ((Double)objHeight).intValue();
            }
            this.layoutData.heightHint = height;
            this.layout(true, true);
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    private String buildFormContent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<style type=\"text/css\">");
        stringBuilder.append("  body {");
        stringBuilder.append("    overflow-y: hidden;");
        stringBuilder.append("  }");
        stringBuilder.append("</style>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body onload='window.onresize = refresh();'>");
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            stringBuilder.append("<H1>");
            stringBuilder.append(this.title);
            stringBuilder.append("</H1>");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.text)) {
            stringBuilder.append(this.text);
        }
        stringBuilder.append("</body>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

