/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.ITextLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextEditAbstractControl;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class TextEditAbstractViewer
extends InfoElementAbstractEditViewer {
    protected TextEditAbstractControl control;
    private Runnable saveChangesDelayed = new Runnable(){

        @Override
        public void run() {
            IIEContentProvider contentProvider = (IIEContentProvider)TextEditAbstractViewer.this.getContentProvider();
            ITextLabelProvider labelProvider = (ITextLabelProvider)TextEditAbstractViewer.this.getLabelProvider();
            InfoElement element = contentProvider.getElement(TextEditAbstractViewer.this.getInput());
            if (element != null && labelProvider.getText(element) != null) {
                boolean update = false;
                if (labelProvider.getText(element).length() != TextEditAbstractViewer.this.control.getText().length()) {
                    update = true;
                } else if (labelProvider.getText(element).length() > 4096) {
                    update = true;
                } else if (!labelProvider.getText(element).equals(TextEditAbstractViewer.this.control.getText())) {
                    update = true;
                }
                if (update) {
                    TextEditAbstractViewer.this.getPropertyModifier().setValue(TextEditAbstractViewer.this.getInput(), InfoelementsPackage.Literals.TEXT_IE__CONTENTS, TextEditAbstractViewer.this.control.getText());
                }
            }
        }
    };

    public TextEditAbstractViewer(TextEditAbstractControl textIEComposite) {
        this.control = textIEComposite;
        this.control.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Display.getDefault().timerExec(800, TextEditAbstractViewer.this.saveChangesDelayed);
            }
        });
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ITextLabelProvider labelProvider = (ITextLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            String text = labelProvider.getText(element);
            if (!this.control.isDisposed() && !text.equals(this.control.getText())) {
                this.control.setText(text);
                this.control.addVariables((List<VariableIEContents>)element.getVariables());
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ITextLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        Assert.isTrue((this.getPropertyModifier() != null ? 1 : 0) != 0, (String)"TextViewer must have a property modifier when input is set.");
        Assert.isTrue((boolean)(input instanceof TextIE), (String)"Input of TextViewer must be of TextIE type.");
        super.setInput(input);
    }
}

