/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.ITextLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextDisplayAbstractControl;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Control;

public abstract class TextDisplayAbstractViewer
extends InfoElementAbstractDisplayViewer {
    private TextDisplayAbstractControl control;

    public TextDisplayAbstractViewer(TextDisplayAbstractControl textDisplayControl) {
        this.control = textDisplayControl;
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ITextLabelProvider labelProvider = (ITextLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            String text = labelProvider.getText(element);
            if (!this.control.isDisposed()) {
                this.control.setTitle(element.getTitle());
                this.control.setText(text);
                this.control.refresh();
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ITextLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        Assert.isTrue((boolean)(input instanceof TextIE), (String)"Input of TextViewer must be of TextIE type.");
        super.setInput(input);
        TextIE textIE = (TextIE)input;
        textIE.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getTextIE_Contents()) {
                    TextDisplayAbstractViewer.this.control.setText(msg.getNewStringValue());
                    TextDisplayAbstractViewer.this.control.refresh();
                } else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title()) {
                    TextDisplayAbstractViewer.this.control.setTitle(msg.getNewStringValue());
                    TextDisplayAbstractViewer.this.control.refresh();
                }
            }
        });
    }
}

