/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location.ILocationLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location.LocationEditControl;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.LocationIE;
import es.upv.dsic.issi.dplfw.infoelements.MapType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class LocationEditViewer
extends InfoElementAbstractEditViewer {
    LocationEditControl control;

    public LocationEditViewer(Composite parent) {
        this(parent, 0);
    }

    public LocationEditViewer(Composite parent, int style) {
        this(new LocationEditControl(parent, style));
    }

    public LocationEditViewer(LocationEditControl locationIEComposite) {
        this.control = locationIEComposite;
        MapType[] mapTypeArray = MapType.values();
        int n = mapTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapType type = mapTypeArray[n2];
            this.control.getMapTypeCombo().add(type.getName());
            ++n2;
        }
        this.addListeners();
    }

    private void addListeners() {
        this.control.getLatitudeSpinner().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                float value = LocationEditViewer.getFloatValueFromSpinner((Spinner)e.getSource());
                LocationEditViewer.this.getPropertyModifier().setValue(LocationEditViewer.this.getInput(), 11, Float.valueOf(value));
            }
        });
        this.control.getLatitudeSpinner().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                float value = LocationEditViewer.getFloatValueFromSpinner((Spinner)e.getSource());
                LocationEditViewer.this.getPropertyModifier().setValue(LocationEditViewer.this.getInput(), 11, Float.valueOf(value));
            }
        });
        this.control.getLongitudeSpinner().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                float value = LocationEditViewer.getFloatValueFromSpinner((Spinner)e.getSource());
                LocationEditViewer.this.getPropertyModifier().setValue(LocationEditViewer.this.getInput(), 12, Float.valueOf(value));
            }
        });
        this.control.getLongitudeSpinner().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                float value = LocationEditViewer.getFloatValueFromSpinner((Spinner)e.getSource());
                LocationEditViewer.this.getPropertyModifier().setValue(LocationEditViewer.this.getInput(), 12, Float.valueOf(value));
            }
        });
        this.control.getZoomSpinner().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LocationEditViewer.checkLocationPreview((LocationIE)LocationEditViewer.this.getInput());
                LocationEditViewer.this.getPropertyModifier().setValue(((LocationIE)LocationEditViewer.this.getInput()).getPreview(), 0, ((Spinner)e.getSource()).getSelection());
            }
        });
        this.control.getZoomSpinner().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LocationEditViewer.checkLocationPreview((LocationIE)LocationEditViewer.this.getInput());
                LocationEditViewer.this.getPropertyModifier().setValue(((LocationIE)LocationEditViewer.this.getInput()).getPreview(), 0, ((Spinner)e.getSource()).getSelection());
            }
        });
        this.control.getMapTypeCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LocationEditViewer.checkLocationPreview((LocationIE)LocationEditViewer.this.getInput());
                LocationEditViewer.this.getPropertyModifier().setValue(((LocationIE)LocationEditViewer.this.getInput()).getPreview(), 1, ((Combo)e.getSource()).getSelection());
            }
        });
    }

    private static void checkLocationPreview(LocationIE input) {
        if (input.getPreview() == null) {
            input.setPreview(InfoelementsFactory.eINSTANCE.createLocationMapPreviewIE());
        }
    }

    private static float getFloatValueFromSpinner(Spinner spinner) {
        float value = (float)spinner.getSelection() / (float)Math.pow(10.0, spinner.getDigits());
        return value;
    }

    private static void setFloatValueToSpinner(Spinner spinner, float value) {
        spinner.setSelection((int)((double)value * Math.pow(10.0, spinner.getDigits())));
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ILocationLabelProvider labelProvider = (ILocationLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            float lat = labelProvider.getLatitude(element);
            float lon = labelProvider.getLatitude(element);
            int zoom = labelProvider.getZoom(element);
            MapType type = labelProvider.getMapType(element);
            byte[] bytes = labelProvider.getPreviewBytes(element);
            if (!this.control.isDisposed()) {
                LocationEditViewer.setFloatValueToSpinner(this.control.getLongitudeSpinner(), lat);
                LocationEditViewer.setFloatValueToSpinner(this.control.getLatitudeSpinner(), lon);
                this.control.getZoomSpinner().setSelection(zoom);
                this.control.getMapTypeCombo().setText(type != null ? type.getName() : "");
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILocationLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        Assert.isTrue((this.getPropertyModifier() != null ? 1 : 0) != 0, (String)"LocationEditViewer must have a property modifier when input is set.");
        super.setInput(input);
        Assert.isTrue((boolean)(input instanceof LocationIE), (String)"Input of LocationEditViewer must be of LocationIE type.");
    }
}

