/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import java.util.Locale;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LocationEditControl
extends Composite {
    private Composite browserComposite;
    private Composite editComposite;
    private Spinner latitudeSpinner;
    private Spinner longitudeSpinner;
    private Spinner zoomSpinner;
    private Combo mapTypeCombo;
    private Browser browser;

    public LocationEditControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new TableWrapLayout());
        this.editComposite = new Composite((Composite)this, 0);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.makeColumnsEqualWidth = false;
        this.editComposite.setLayout((Layout)tableWrapLayout);
        this.editComposite.setLayoutData((Object)new TableWrapData(256));
        this.browserComposite = new Composite(this.editComposite, 0x800800);
        this.browserComposite.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout browserCompositeLayout = new TableWrapLayout();
        this.browserComposite.setLayout((Layout)browserCompositeLayout);
        this.browser = new Browser(this.browserComposite, 0);
        TableWrapData browserLayoutData = new TableWrapData(256);
        browserLayoutData.maxWidth = 0;
        browserLayoutData.heightHint = 480;
        this.browser.setLayoutData((Object)browserLayoutData);
        this.browser.setText(this.getInitialBrowserContents(), true);
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                LocationEditControl.this.browser.execute("initiate_geolocation();");
            }

            public void changed(ProgressEvent event) {
            }
        });
        Composite attribsComposite = new Composite(this.editComposite, 0);
        TableWrapLayout sizesCompositeLayout = new TableWrapLayout();
        sizesCompositeLayout.numColumns = 2;
        sizesCompositeLayout.makeColumnsEqualWidth = false;
        sizesCompositeLayout.horizontalSpacing = 10;
        attribsComposite.setLayout((Layout)sizesCompositeLayout);
        Label latitudeLabel = new Label(attribsComposite, 0);
        latitudeLabel.setText("Latitude:");
        this.latitudeSpinner = new Spinner(attribsComposite, 2052);
        this.latitudeSpinner.setLayoutData((Object)new TableWrapData(256));
        this.latitudeSpinner.setDigits(6);
        this.latitudeSpinner.setMaximum(90000000);
        this.latitudeSpinner.setMinimum(-90000000);
        this.latitudeSpinner.setIncrement(1000);
        Label longitudeLabel = new Label(attribsComposite, 0);
        longitudeLabel.setText("Latitude:");
        this.longitudeSpinner = new Spinner(attribsComposite, 2052);
        this.longitudeSpinner.setLayoutData((Object)new TableWrapData(256));
        this.longitudeSpinner.setDigits(6);
        this.longitudeSpinner.setMaximum(180000000);
        this.longitudeSpinner.setMinimum(-180000000);
        this.longitudeSpinner.setIncrement(1000);
        Label zoomLabel = new Label(attribsComposite, 0);
        zoomLabel.setText("Zoom:");
        this.zoomSpinner = new Spinner(attribsComposite, 2048);
        this.zoomSpinner.setLayoutData((Object)new TableWrapData(256));
        this.zoomSpinner.setMinimum(0);
        this.zoomSpinner.setMaximum(20);
        this.zoomSpinner.setLayoutData((Object)new TableWrapData(256));
        Label mapTypeLabel = new Label(attribsComposite, 0);
        mapTypeLabel.setText("Map type:");
        this.mapTypeCombo = new Combo(attribsComposite, 0x80080C);
        this.mapTypeCombo.setLayoutData((Object)new TableWrapData(256));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.layout(true, true);
    }

    private String getInitialBrowserContents() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("  <head>");
        builder.append("\t<script>");
        builder.append("\t\tfunction initiate_geolocation() {");
        builder.append("\t\t\tif (navigator.geolocation) {");
        builder.append("\t\t\t\tnavigator.geolocation.getCurrentPosition(handle_geolocation_query);");
        builder.append("\t\t\t} else {");
        builder.append("\t\t\t\tvar image_url = \"http://maps.google.com/maps?q=" + Locale.getDefault().getDisplayCountry() + "&output=embed&t=k\";");
        builder.append("\t\t\t\twindow.location.href=image_url;");
        builder.append("\t\t\t}");
        builder.append("\t\t}");
        builder.append("\t\tfunction handle_geolocation_query(position)");
        builder.append("\t\t{  ");
        builder.append("\t\t\tvar image_url = \"http://maps.google.com/maps?ll=\" + position.coords.latitude + \",\" +");
        builder.append("\t\t\t\t\t\t\tposition.coords.longitude + \"&output=embed&t=k&iwloc=near\";");
        builder.append("\t\t\twindow.location.href=image_url;");
        builder.append("\t\t}");
        builder.append("\t\t</script>");
        builder.append("\t</head>");
        builder.append("\t<body>");
        builder.append("\t</body>");
        builder.append("</html>");
        return builder.toString();
    }

    public Spinner getLatitudeSpinner() {
        return this.latitudeSpinner;
    }

    public Spinner getLongitudeSpinner() {
        return this.longitudeSpinner;
    }

    public Spinner getZoomSpinner() {
        return this.zoomSpinner;
    }

    public Combo getMapTypeCombo() {
        return this.mapTypeCombo;
    }

    public void refresh() {
    }
}

