/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link.ILinkLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link.LinkDisplayControl;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.LinkIE;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LinkDisplayViewer
extends InfoElementAbstractDisplayViewer {
    private LinkDisplayControl control;

    public LinkDisplayViewer(Composite parent) {
        this(parent, 0);
    }

    public LinkDisplayViewer(LinkDisplayControl linkDisplayControl) {
        this.control = linkDisplayControl;
    }

    public LinkDisplayViewer(Composite parent, int style) {
        this(new LinkDisplayControl(parent, style));
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ILinkLabelProvider labelProvider = (ILinkLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            String text = labelProvider.getLink(element);
            if (!this.control.isDisposed()) {
                this.control.setTitle(element.getTitle());
                this.control.setLink(text);
                this.control.refresh();
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILinkLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        Assert.isTrue((boolean)(input instanceof LinkIE), (String)"Input of TextViewer must be of LinkIE type.");
        super.setInput(input);
        LinkIE linkIE = (LinkIE)input;
        linkIE.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (LinkDisplayViewer.this.control.isVisible() && (msg.getFeature() == InfoelementsPackage.eINSTANCE.getLinkIE_Contents() || msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title())) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            LinkDisplayViewer.this.refresh();
                        }
                    });
                }
            }
        });
    }
}

