/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.statushandlers.StatusManager;

public class LinkDisplayControl
extends Composite {
    private FormText formText;
    private String title;
    private String link;

    public LinkDisplayControl(Composite parent, int style) {
        super(parent, style);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 20;
        layout.rightMargin = 20;
        layout.topMargin = 20;
        layout.bottomMargin = 20;
        this.setLayout((Layout)layout);
        this.formText = new FormText((Composite)this, 66);
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LinkDisplayControl.this.openLink();
            }
        });
        TableWrapData layoutData = new TableWrapData(256);
        this.formText.setLayoutData((Object)layoutData);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void refresh() {
        this.formText.setFont("TITLE", SWTUtil.getDefaultTitleFont());
        this.formText.setFont(SWTUtil.getDefaultTextFont());
        this.formText.setText(this.buildFormContent(), true, false);
    }

    protected void openLink() {
        try {
            URI uri = new URI(this.link);
            if (StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"http") || StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"https")) {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser("es.upv.dsic.issi.dplfw.infoelements.editorfragments").openURL(uri.toURL());
            } else {
                boolean open = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Open URI?", (String)String.format("The editor is attempting to open the location '%s' with your system's default application. Opening untrusted locations is potentially dangerous. Are you sure you want to continue?", this.link));
                if (open) {
                    Program.launch((String)this.link);
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "es.upv.dsic.issi.dplfw.infoelements.editorfragments", e.getLocalizedMessage(), (Throwable)e), 5);
        }
        catch (MalformedURLException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "es.upv.dsic.issi.dplfw.infoelements.editorfragments", e.getLocalizedMessage(), (Throwable)e), 5);
        }
    }

    private String buildFormContent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form>");
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            stringBuilder.append("<p><span font=\"TITLE\">");
            stringBuilder.append(this.title);
            stringBuilder.append("</span></p><p></p>");
        }
        if (StringUtils.isNotBlank((CharSequence)this.link)) {
            stringBuilder.append("<p><a href=\"");
            stringBuilder.append(this.link);
            stringBuilder.append("\">");
            stringBuilder.append(this.title);
            stringBuilder.append("</a></p>");
        }
        stringBuilder.append("</form>");
        return stringBuilder.toString();
    }
}

